/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.logging;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.simantics.logging.LogProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBAndMetadataLogProvider
implements LogProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBAndMetadataLogProvider.class);

    @Override
    public List<Path> get() {
        Path metadataLogLocation;
        ArrayList<Path> logs = new ArrayList<Path>();
        Path dbClientLog = DBAndMetadataLogProvider.getDBClientLogLocation();
        if (dbClientLog != null) {
            logs.add(dbClientLog);
        }
        if ((metadataLogLocation = DBAndMetadataLogProvider.getMetadataLogLocation()) != null) {
            logs.add(metadataLogLocation);
        }
        return logs;
    }

    private static Path getDBClientLogLocation() {
        Bundle bundle = Platform.getBundle((String)"org.simantics.db.common");
        try {
            Class forName = bundle.loadClass("org.simantics.db.common.internal.config.InternalClientConfig");
            Field field = forName.getField("DB_CLIENT_LOG_FILE");
            String value = (String)field.get(null);
            return Paths.get(value, new String[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Could not read db-client.log location", (Throwable)e);
            return null;
        }
    }

    private static Path getMetadataLogLocation() {
        String prop = System.getProperty("osgi.instance.area", null);
        if (prop != null) {
            try {
                URL url = new URL(prop);
                if ("file".equals(url.getProtocol())) {
                    Path path = Paths.get(new File(url.getFile()).getAbsolutePath(), new String[0]);
                    return path.resolve(".metadata").resolve(".log");
                }
                LOGGER.warn("Unsupported protocol {}", (Object)url);
            }
            catch (Throwable t) {
                LOGGER.error("Could not get .metadata/.log", t);
            }
        }
        return null;
    }
}

