/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.svg.export;

import java.awt.Shape;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGShape;
import org.simantics.db.common.utils.Logger;
import org.simantics.scenegraph.utils.SVGPassthruShape;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SVGShapeWithPassthruSupport
extends SVGShape {
    private DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public SVGShapeWithPassthruSupport(SVGGeneratorContext generatorCtx) {
        super(generatorCtx);
        this.dbf.setValidating(false);
        this.dbf.setExpandEntityReferences(false);
        try {
            this.dbf.setFeature("http://xml.org/sax/features/namespaces", false);
            this.dbf.setFeature("http://xml.org/sax/features/validation", false);
            this.dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element toSVG(Shape shape) {
        if (!(shape instanceof SVGPassthruShape)) {
            return super.toSVG(shape);
        }
        String source = ((SVGPassthruShape)shape).getSource();
        try {
            Document owner = this.generatorContext.getDOMFactory();
            HashMap<String, String> defsMap = (HashMap<String, String>)owner.getUserData("defs-map");
            if (defsMap == null) {
                defsMap = new HashMap<String, String>();
                owner.setUserData("defs-map", defsMap, null);
            }
            HashMap<String, String> hashMap = defsMap;
            synchronized (hashMap) {
                String symbolId = (String)defsMap.get(source);
                if (symbolId != null) {
                    Element element = owner.createElement("use");
                    element.setAttribute("xlink:href", "#" + symbolId);
                    return element;
                }
                symbolId = "S" + defsMap.size();
                defsMap.put(source, symbolId);
                DocumentBuilder db = this.dbf.newDocumentBuilder();
                Document doc = db.parse(new ByteArrayInputStream(source.getBytes("UTF-8")));
                Element node = doc.getDocumentElement();
                Node localNode = owner.importNode(node, true);
                if (localNode instanceof Element) {
                    Element g = this.generatorContext.getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "g");
                    Element e = (Element)localNode;
                    e.setAttribute("id", symbolId);
                    e.setAttribute("overflow", "visible");
                    g.appendChild(localNode);
                    return g;
                }
                return null;
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
        catch (ParserConfigurationException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
        catch (SAXException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }
}

