/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.SearchResultColumn;
import org.simantics.workbench.search.SearchResultRow;
import org.simantics.workbench.search.StringUtil;

public class NameAndTypeRow
implements SearchResultRow {
    public static final List<SearchResultColumn> columns = new ArrayList<SearchResultColumn>();
    public NamedResource resource;
    public NamedResource parent;
    public Collection<NamedResource> types;
    public Collection<NamedResource> principalTypes;

    static {
        columns.add(new SearchResultColumn("Name"));
        columns.add(new SearchResultColumn("Type"));
        columns.add(new SearchResultColumn("Part Of"));
    }

    public NamedResource getResource() {
        return this.resource;
    }

    public NamedResource getParent() {
        return this.parent;
    }

    public Collection<NamedResource> getTypes() {
        return this.types;
    }

    public Collection<NamedResource> getPrincipalTypes() {
        return this.principalTypes;
    }

    @Override
    public String getContent(int column) {
        switch (column) {
            case 0: {
                return "<a class=\"small\" href=\"resource:" + this.resource.getResource() + "\"" + (this.resource.getUri() == null ? "" : " title=\"" + URIStringUtils.unescape((String)this.resource.getUri())) + "\">" + StringUtil.escape(this.resource.getName()) + "</a>";
            }
            case 1: {
                String s = "";
                for (NamedResource type : this.principalTypes) {
                    s = String.valueOf(s) + "<a class=\"small\" href=\"resource:" + type.getResource() + "\"" + (type.getUri() == null ? "" : " title=\"" + URIStringUtils.unescape((String)type.getUri())) + "\">" + StringUtil.escape(type.getName()) + "</a>";
                }
                return s;
            }
            case 2: {
                if (this.parent != null) {
                    return "<a class=\"small\" href=\"resource:" + this.parent.getResource() + "\"" + (this.parent.getUri() == null ? "" : " title=\"" + URIStringUtils.unescape((String)this.parent.getUri())) + "\">" + StringUtil.escape(this.parent.getName()) + "</a>";
                }
                return "";
            }
        }
        return "";
    }
}

