/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.interpreted;

import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.runtime.function.Function;

public class IApply
implements IExpression {
    private final IExpression function;
    private final IExpression[] parameters;

    public IApply(IExpression function, IExpression[] parameters) {
        if (function instanceof IApply) {
            IApply apply = (IApply)function;
            this.function = apply.function;
            this.parameters = new IExpression[apply.parameters.length + parameters.length];
            System.arraycopy(apply.parameters, 0, this.parameters, 0, apply.parameters.length);
            System.arraycopy(parameters, 0, this.parameters, apply.parameters.length, parameters.length);
        } else {
            this.function = function;
            this.parameters = parameters;
        }
    }

    @Override
    public Object execute(Object[] variableBindings) {
        Object[] parameterValues = new Object[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            parameterValues[i] = this.parameters[i].execute(variableBindings);
            ++i;
        }
        return ((Function)this.function.execute(variableBindings)).applyArray(parameterValues);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        b.append(this.function);
        IExpression[] iExpressionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression parameter = iExpressionArray[n2];
            b.append(' ');
            b.append(parameter);
            ++n2;
        }
        b.append(')');
        return b.toString();
    }
}

