/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa.exits;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.internal.codegen.continuations.BranchRef;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.If;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class Switch
extends SSAExit
implements ValRefBinder {
    ValRef scrutinee;
    BranchRef[] branches;

    public Switch(int lineNumber, ValRef scrutinee, BranchRef[] branches) {
        super(lineNumber);
        this.scrutinee = scrutinee;
        this.branches = branches;
        scrutinee.setParent(this);
        BranchRef[] branchRefArray = branches;
        int n = branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = branchRefArray[n2];
            branch.cont.setParent(this);
            ++n2;
        }
    }

    public ValRef getScrutinee() {
        return this.scrutinee;
    }

    public BranchRef[] getBranches() {
        return this.branches;
    }

    private boolean isIntegerSwitch() {
        if (this.scrutinee.getType() != Types.INTEGER) {
            return false;
        }
        BranchRef[] branchRefArray = this.branches;
        int n = this.branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = branchRefArray[n2];
            if (branch.constructor != null && !(branch.constructor instanceof IntegerConstant)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void generateIntegerSwitch(MethodBuilder mb) {
        Cont cont;
        int defaultId = 0;
        while (defaultId < this.branches.length - 1 && this.branches[defaultId].constructor != null) {
            ++defaultId;
        }
        int[] values = new int[defaultId];
        Cont[] continuations = new Cont[defaultId + 1];
        TIntObjectHashMap labelMap = new TIntObjectHashMap(defaultId);
        int i = 0;
        while (i < defaultId) {
            int value;
            values[i] = value = ((IntegerConstant)this.branches[i].constructor).getValue();
            cont = this.branches[i].cont.getBinding();
            labelMap.put(value, (Object)mb.getLabel(cont));
            continuations[i] = cont;
            ++i;
        }
        Arrays.sort(values);
        Label[] labels = new Label[defaultId];
        int i2 = 0;
        while (i2 < defaultId) {
            labels[i2] = (Label)labelMap.get(values[i2]);
            ++i2;
        }
        cont = this.branches[defaultId].cont.getBinding();
        Label defaultLabel = mb.getLabel(cont);
        continuations[defaultId] = cont;
        mb.push(this.scrutinee, Types.INTEGER);
        mb.switch_(values, labels, defaultLabel);
        Cont[] contArray = continuations;
        int n = continuations.length;
        int n2 = 0;
        while (n2 < n) {
            cont = contArray[n2];
            mb.ensureExists(cont);
            ++n2;
        }
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        mb.lineNumber(this.lineNumber);
        if (this.isIntegerSwitch()) {
            this.generateIntegerSwitch(mb);
            return;
        }
        int i = 0;
        while (i < this.branches.length) {
            BranchRef branch = this.branches[i];
            if (branch.constructor == null) {
                mb.jump(branch.cont);
            } else if (i < this.branches.length - 1) {
                Label failure = mb.createLabel();
                branch.constructor.deconstruct(mb, this.scrutinee, branch.cont.getBinding(), failure);
                mb.setLocation(failure);
            } else {
                branch.constructor.deconstruct(mb, this.scrutinee, branch.cont.getBinding(), null);
            }
            ++i;
        }
    }

    @Override
    public void toString(PrintingContext context) {
        context.append("switch ");
        context.append(this.scrutinee);
        Object[] objectArray = this.branches;
        int n = this.branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = objectArray[n2];
            context.append('\n');
            context.indentation();
            if (branch.constructor == null) {
                context.append("otherwise");
            } else {
                context.append(branch.constructor.toString());
            }
            context.append(" -> ");
            Cont cont = branch.cont.getBinding();
            if (cont instanceof SSABlock) {
                SSABlock block = (SSABlock)cont;
                context.append(cont);
                context.append('\n');
                context.addBlock(block);
            } else {
                context.append(cont);
                context.append('\n');
            }
            ++n2;
        }
        objectArray = this.getSuccessors();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object block = objectArray[n2];
            context.addBlock((SSABlock)block);
            ++n2;
        }
    }

    @Override
    public void validate(SSAValidationContext context) {
        context.validate(this.scrutinee);
        if (this.scrutinee.getParent() != this) {
            throw new InternalCompilerError();
        }
        BranchRef[] branchRefArray = this.branches;
        int n = this.branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = branchRefArray[n2];
            context.validate(branch.cont);
            if (branch.cont.getParent() != this) {
                throw new InternalCompilerError();
            }
            ++n2;
        }
    }

    @Override
    public void destroy() {
        this.scrutinee.remove();
        BranchRef[] branchRefArray = this.branches;
        int n = this.branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = branchRefArray[n2];
            branch.cont.remove();
            ++n2;
        }
    }

    @Override
    public SSAExit copy(CopyContext context) {
        return new Switch(this.lineNumber, context.copy(this.scrutinee), BranchRef.copy(context, this.branches));
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        this.scrutinee.replace(vars, replacements);
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        if (Types.equals(this.scrutinee.getType(), Types.BOOLEAN)) {
            SSAExit newExit;
            ContRef thenTarget = null;
            ContRef elseTarget = null;
            BranchRef[] branchRefArray = this.branches;
            int n = this.branches.length;
            int n2 = 0;
            while (n2 < n) {
                BranchRef branch = branchRefArray[n2];
                boolean used = false;
                if (branch.constructor == null) {
                    if (thenTarget == null) {
                        thenTarget = branch.cont;
                        used = true;
                    }
                    if (elseTarget == null) {
                        elseTarget = branch.cont;
                        used = true;
                    }
                } else if (((BooleanConstant)branch.constructor).getValue()) {
                    if (thenTarget == null) {
                        thenTarget = branch.cont;
                        used = true;
                    }
                } else if (elseTarget == null) {
                    elseTarget = branch.cont;
                    used = true;
                }
                if (!used) {
                    branch.cont.remove();
                }
                ++n2;
            }
            if (elseTarget == null) {
                elseTarget = thenTarget;
            } else if (thenTarget == null) {
                thenTarget = elseTarget;
            }
            if (thenTarget == elseTarget) {
                this.scrutinee.remove();
                newExit = new Jump(this.lineNumber, thenTarget, new ValRef[0]);
            } else {
                newExit = new If(this.lineNumber, this.scrutinee, thenTarget, elseTarget);
            }
            this.getParent().setExit(newExit);
            context.markModified("switch-to-if");
            newExit.simplify(context);
        } else if (this.branches.length == 1 && Switch.isConstructorParameterless(this.branches[0])) {
            this.scrutinee.remove();
            this.getParent().setExit(new Jump(this.lineNumber, this.branches[0].cont, new ValRef[0]));
        }
    }

    private static boolean isConstructorParameterless(BranchRef branch) {
        return branch.constructor == null || branch.constructor instanceof NoRepConstant;
    }

    @Override
    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
        this.scrutinee.collectFreeVariables(function, vars);
    }

    @Override
    public Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy) {
        if (proxy == null) {
            proxy = contRef.getBinding().createProxy(this.getParent().getParent(), newParameters, oldParameters);
        }
        ContRef proxyRef = proxy.createOccurrence();
        proxyRef.setParent(this);
        BranchRef[] branchRefArray = this.branches;
        int n = this.branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = branchRefArray[n2];
            if (branch.cont == contRef) {
                branch.cont = proxyRef;
                break;
            }
            ++n2;
        }
        return proxy;
    }

    @Override
    public SSABlock[] getSuccessors() {
        ArrayList<SSABlock> result = new ArrayList<SSABlock>(this.branches.length);
        BranchRef[] branchRefArray = this.branches;
        int n = this.branches.length;
        int n2 = 0;
        while (n2 < n) {
            BranchRef branch = branchRefArray[n2];
            Cont cont = branch.cont.getBinding();
            if (cont instanceof SSABlock) {
                result.add((SSABlock)cont);
            }
            ++n2;
        }
        return result.toArray(new SSABlock[result.size()]);
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
        visitor.visit(this.scrutinee);
    }

    @Override
    public void cleanup() {
        this.scrutinee.remove();
    }
}

