/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.references;

import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValSpecialization;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValRef
implements IVal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValRef.class);
    public static final ValRef[] EMPTY_ARRAY = new ValRef[0];
    Val binding;
    ValRef prev;
    ValRef next;
    ValRefBinder parent;
    Type[] parameters;
    int removeModiId = -1;

    public ValRef(Type[] parameters) {
        this.parameters = parameters;
    }

    ValRef(Val binding, Type[] parameters) {
        this.parameters = parameters;
        this.setBinding(binding);
    }

    public void setBinding(Val binding) {
        this.binding = binding;
        ValRef head = binding.occurrence;
        binding.occurrence = this;
        this.next = head;
        this.prev = null;
        if (head != null) {
            head.prev = this;
        }
    }

    public void remove() {
        if (this.prev == null) {
            try {
                this.binding.occurrence = this.next;
            }
            catch (NullPointerException e) {
                LOGGER.error("removeModiId = " + this.removeModiId);
                LOGGER.error("current ModiId = " + SSASimplificationContext.modiId, (Throwable)e);
                throw new InternalCompilerError("The ValRef has already been removed.");
            }
        } else {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        if (SCLCompilerConfiguration.DEBUG) {
            this.next = null;
            this.prev = null;
            this.binding = null;
        }
        this.removeModiId = SSASimplificationContext.modiId;
    }

    public Val getBinding() {
        return this.binding;
    }

    public ValRef getNext() {
        return this.next;
    }

    public static Val[] getBindings(ValRef[] refs) {
        Val[] result = new Val[refs.length];
        int i = 0;
        while (i < refs.length) {
            result[i] = refs[i].getBinding();
            ++i;
        }
        return result;
    }

    @Override
    public ValRef createOccurrence() {
        return this.binding.createOccurrence(this.parameters);
    }

    @Override
    public ValRef createOccurrence(Type ... otherParameters) {
        return this.binding.createOccurrence(Types.concat(this.parameters, otherParameters));
    }

    @Override
    public IVal createSpecialization(Type ... otherParameters) {
        return new ValSpecialization(this.binding, Types.concat(this.parameters, otherParameters));
    }

    public void setParent(ValRefBinder parent) {
        this.parent = parent;
    }

    @Override
    public Type getType() {
        if (this.parameters.length == 0) {
            return this.binding.getType();
        }
        return Types.instantiate(this.binding.getType(), this.parameters);
    }

    public static ValRef[] createOccurrences(IVal[] vals) {
        ValRef[] result = new ValRef[vals.length];
        int i = 0;
        while (i < vals.length) {
            result[i] = vals[i].createOccurrence();
            ++i;
        }
        return result;
    }

    public static <T extends IVal> ValRef[] createOccurrences(List<T> vals) {
        ValRef[] result = new ValRef[vals.size()];
        int i = 0;
        while (i < vals.size()) {
            result[i] = ((IVal)vals.get(i)).createOccurrence();
            ++i;
        }
        return result;
    }

    public Type[] getTypeParameters() {
        return this.parameters;
    }

    public Type getTypeParameter(int i) {
        return this.parameters[i];
    }

    public static ValRef[] concat(ValRef[] refs1, ValRef[] refs2) {
        ValRef[] result = new ValRef[refs1.length + refs2.length];
        int i = 0;
        while (i < refs1.length) {
            result[i] = refs1[i];
            ++i;
        }
        i = 0;
        while (i < refs2.length) {
            result[refs1.length + i] = refs2[i];
            ++i;
        }
        return result;
    }

    @Override
    public void push(MethodBuilder mb) {
        this.binding.push(mb);
    }

    public ValRefBinder getParent() {
        return this.parent;
    }

    public SSAFunction getParentFunction() {
        return this.parent.getParentFunction();
    }

    public void replace(TVar[] vars, Type[] replacements) {
        int i = 0;
        while (i < this.parameters.length) {
            Type oldType = this.parameters[i];
            Type newType = this.parameters[i].replace(vars, replacements);
            if (oldType != newType) {
                Type[] newParameters = new Type[this.parameters.length];
                int j = 0;
                while (j < i) {
                    newParameters[j] = this.parameters[j];
                    ++j;
                }
                newParameters[i] = newType;
                j = i + 1;
                while (j < this.parameters.length) {
                    newParameters[j] = this.parameters[j].replace(vars, replacements);
                    ++j;
                }
                this.parameters = newParameters;
                return;
            }
            ++i;
        }
    }

    public void setTypeParameters(Type[] parameters) {
        this.parameters = parameters;
    }

    public static ValRef[] copy(ValRef[] refs) {
        ValRef[] result = new ValRef[refs.length];
        int i = 0;
        while (i < refs.length) {
            result[i] = refs[i].copy();
            ++i;
        }
        return result;
    }

    public ValRef copy() {
        return this.binding.createOccurrence(this.parameters);
    }

    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
        BoundVar var;
        if (this.binding instanceof BoundVar && (var = (BoundVar)this.binding).getFunctionParent() != function) {
            vars.add(this);
        }
    }

    public void replaceBy(Val binding) {
        this.remove();
        this.setBinding(binding);
    }

    @Override
    public Type apply(MethodBuilder mb, Type[] typeParameters, Val ... parameters) {
        return this.binding.apply(mb, Types.concat(this.parameters, typeParameters), parameters);
    }

    public void replaceByApply(Val function, Val ... parameters) {
        this.getParent().replaceByApply(this, function, this.parameters, parameters);
    }

    @Override
    public Object realizeValue(TransientClassBuilder classLoader) {
        return this.binding.realizeValue(classLoader);
    }

    @Override
    public void setLabel(String label) {
    }

    public void updateParentEffect() {
        LetApply apply;
        if (this.parent instanceof LetApply && (apply = (LetApply)this.parent).getFunction() == this) {
            apply.updateEffect();
        }
    }
}

