/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.planning;

import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.chr.planning.PrePlanItem;

public class PlanPriorityQueue {
    PrePlanItem[] items = new PrePlanItem[16];
    int size = 0;

    public PrePlanItem head() {
        return this.items[0];
    }

    public void pop() {
        this.items[0].queuePos = -1;
        --this.size;
        if (this.size > 0) {
            PrePlanItem e;
            this.items[0] = e = this.items[this.size];
            e.queuePos = 0;
            this.adjustDown(e);
        }
        this.items[this.size] = null;
    }

    public void add(PrePlanItem e) {
        if (this.size == this.items.length) {
            this.items = Arrays.copyOf(this.items, this.size + this.size / 2);
        }
        this.items[this.size] = e;
        e.queuePos = this.size++;
        this.adjustUp(e);
    }

    private boolean adjustUp(PrePlanItem e) {
        int pos = e.queuePos;
        while (pos > 0) {
            int upId = (pos - 1) / 2;
            PrePlanItem upE = this.items[upId];
            if (e.compare(upE) >= 0) break;
            this.items[pos] = upE;
            upE.queuePos = pos;
            pos = upId;
        }
        if (e.queuePos != pos) {
            this.items[pos] = e;
            e.queuePos = pos;
            return true;
        }
        return false;
    }

    private void adjustDown(PrePlanItem e) {
        int downId;
        int pos = e.queuePos;
        while ((downId = pos * 2 + 1) < this.size) {
            PrePlanItem downE;
            if (downId + 1 < this.size && this.items[downId].compare(this.items[downId + 1]) > 0) {
                ++downId;
            }
            if (e.compare(downE = this.items[downId]) <= 0) break;
            this.items[pos] = downE;
            downE.queuePos = pos;
            pos = downId;
        }
        if (e.queuePos != pos) {
            this.items[pos] = e;
            e.queuePos = pos;
        }
    }

    public void adjust(PrePlanItem e) {
        if (e.queuePos == -1) {
            return;
        }
        if (!this.adjustUp(e)) {
            this.adjustDown(e);
        }
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

