/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.completions.parsing;

import java.io.IOException;
import java.io.Reader;

public class SubstringReader
extends Reader {
    private String str;
    private int end;
    private int pos;
    private int mark;

    public SubstringReader(String str, int begin, int end) {
        this.str = str;
        this.pos = begin;
        this.mark = begin;
        this.end = end;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.end) {
            return -1;
        }
        return this.str.charAt(this.pos++);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.pos >= this.end) {
            return -1;
        }
        int n = Math.min(this.end - this.pos, len);
        this.str.getChars(this.pos, this.pos + n, cbuf, off);
        this.pos += n;
        return n;
    }

    @Override
    public long skip(long ns) throws IOException {
        if (this.pos >= this.end) {
            return 0L;
        }
        long n = Math.min((long)(this.end - this.pos), ns);
        n = Math.max((long)(-this.pos), n);
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        this.mark = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }
}

