/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.util.concurrent.Executor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.simantics.utils.threads.IThreadWorkQueue;

public class SWTThread
implements IThreadWorkQueue,
Executor {
    private final Display display;
    private final boolean executeAsync;

    public static IThreadWorkQueue getThreadAccess(Display display, boolean executeAsync) {
        return new SWTThread(display, executeAsync);
    }

    public static IThreadWorkQueue getThreadAccess(Display display) {
        return SWTThread.getThreadAccess(display, false);
    }

    public static IThreadWorkQueue getThreadAccess(Widget widget) {
        return new SWTThread(widget.getDisplay(), false);
    }

    public static IThreadWorkQueue getThreadAccess() {
        return new SWTThread(Display.getDefault(), false);
    }

    SWTThread(Display display, boolean executeAsync) {
        this.display = display;
        this.executeAsync = executeAsync;
    }

    public Thread asyncExec(Runnable runnable) {
        if (this.display.isDisposed()) {
            return null;
        }
        this.display.asyncExec(runnable);
        return this.display.getThread();
    }

    public boolean syncExec(Runnable runnable) {
        if (this.display.isDisposed()) {
            return false;
        }
        if (this.display.getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            this.display.syncExec(runnable);
        }
        return true;
    }

    public boolean currentThreadAccess() {
        if (this.display.isDisposed()) {
            return false;
        }
        return this.display.getThread() == Thread.currentThread();
    }

    public Thread getThread() {
        if (this.display.isDisposed()) {
            return null;
        }
        return this.display.getThread();
    }

    public String toString() {
        return "SWT Thread";
    }

    @Override
    public void execute(Runnable command) {
        if (this.executeAsync) {
            this.asyncExec(command);
        } else {
            this.syncExec(command);
        }
    }
}

