/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.simantics.Simantics;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.ChartDropTarget;
import org.simantics.jfreechart.ChartPanelElement;
import org.simantics.jfreechart.ElementContainer;
import org.simantics.jfreechart.internal.Activator;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.utils.RunnableWithObject;

public class ChartPanel
extends ViewPart {
    private Composite body;
    private ScrolledComposite sc;
    private IDialogSettings settings;
    private LinkedHashMap<Resource, ChartPanelElement> charts;
    private ArrayList<Resource> minimizedResources;
    private ArrayList<ChartPanelElement> chartElements;
    public static final String CHART_PANEL_SETTINGS = "CHART_PANEL_SETTINGS";
    public static final String CHARTS = "CHART_PANEL_CHARTS";
    public static final String MINIMIZED_CHARTS = "CHART_PANEL_MINIMIZED_CHARTS";
    public static final String CHART_PANEL_ORIENTATION = "CHART_PANEL_ORIENTATION";
    public static final String CHART_PANEL_VERTICAL = "CHART_PANEL_ORIENTATION_VERTICAL";
    public static final String CHART_PANEL_HORIZONTAL = "CHART_PANEL_ORIENTATION_HORIZONTAL";
    private boolean vertical = true;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.minimizedResources = new ArrayList();
        this.settings = Activator.getDefault().getDialogSettings().getSection(CHART_PANEL_SETTINGS);
        if (this.settings == null) {
            this.settings = Activator.getDefault().getDialogSettings().addNewSection(CHART_PANEL_SETTINGS);
        }
        if (this.settings.getArray(CHARTS) == null) {
            String[] chartUris = new String[]{};
            this.settings.put(CHARTS, chartUris);
        }
        if (this.settings.getArray(MINIMIZED_CHARTS) == null) {
            String[] minimizedChartUris = new String[]{};
            this.settings.put(MINIMIZED_CHARTS, minimizedChartUris);
        }
        this.charts = new LinkedHashMap();
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    String[] minimizedUris;
                    String[] chartURIs;
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    Resource chart = null;
                    String[] stringArray = chartURIs = ChartPanel.this.settings.getArray(ChartPanel.CHARTS);
                    int n = chartURIs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String uri = stringArray[n2];
                        chart = graph.getPossibleResource(uri);
                        if (chart != null && graph.isInstanceOf(chart, jfree.Chart)) {
                            ChartPanel.this.charts.put(chart, null);
                            ChartPanel.this.setChartExistingListener(chart);
                        }
                        ++n2;
                    }
                    String[] stringArray2 = minimizedUris = ChartPanel.this.settings.getArray(ChartPanel.MINIMIZED_CHARTS);
                    int n3 = minimizedUris.length;
                    n = 0;
                    while (n < n3) {
                        String uri = stringArray2[n];
                        chart = graph.getPossibleResource(uri);
                        if (chart != null && graph.isInstanceOf(chart, jfree.Chart)) {
                            ChartPanel.this.minimizedResources.add(chart);
                        }
                        ++n;
                    }
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        String orientation = this.settings.get(CHART_PANEL_ORIENTATION);
        if (CHART_PANEL_VERTICAL.equals(orientation)) {
            this.vertical = true;
        } else if (CHART_PANEL_HORIZONTAL.equals(orientation)) {
            this.vertical = false;
        }
    }

    public void createPartControl(Composite parent) {
        this.sc = new ScrolledComposite(parent, 768);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this.sc);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.sc);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.getVerticalBar().setIncrement(this.sc.getVerticalBar().getIncrement() * 3);
        this.sc.getHorizontalBar().setIncrement(this.sc.getHorizontalBar().getIncrement() * 3);
        this.body = new Composite((Composite)this.sc, 0);
        GridLayoutFactory.fillDefaults().margins(3, 0).spacing(0, 0).applyTo(this.body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.body);
        this.sc.setContent((Control)this.body);
        this.createContents();
        this.setupDropTarget();
    }

    private void createContents() {
        ElementContainer elementHolder;
        this.chartElements = new ArrayList();
        Control[] controlArray = this.body.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        for (Resource e : this.charts.keySet()) {
            elementHolder = new ElementContainer(this.body, 0);
            elementHolder.setBackground(new Color((Device)elementHolder.getDisplay(), 255, 0, 0));
            ChartPanelElement element = new ChartPanelElement(elementHolder, this, e, 0);
            elementHolder.setLayout((Layout)GridLayoutFactory.copyLayout((GridLayout)((GridLayout)element.getLayout())));
            this.chartElements.add(element);
            this.charts.put(e, element);
            if (!this.minimizedResources.contains(e)) continue;
            element.toggleMinimize();
        }
        elementHolder = new ElementContainer(this.body, 0);
        elementHolder.setBackground(new Color((Device)elementHolder.getDisplay(), 0, 255, 0));
        ChartPanelElement element = new ChartPanelElement(elementHolder, this, null, 0);
        elementHolder.setLayout((Layout)GridLayoutFactory.copyLayout((GridLayout)((GridLayout)element.getLayout())));
        this.chartElements.add(element);
        this.layout();
        this.saveState();
    }

    public void layout() {
        if (this.vertical) {
            GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.body);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.body);
        } else {
            int chartPanels = this.chartElements.size();
            GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(chartPanels).applyTo(this.body);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.body);
        }
        this.body.layout();
        this.sc.setMinSize(this.body.computeSize(-1, -1));
    }

    public void setFocus() {
        if (!this.sc.isDisposed()) {
            this.sc.setFocus();
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        this.saveState();
    }

    public void saveState() {
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    if (ChartPanel.this.settings != null) {
                        String[] uris = new String[ChartPanel.this.chartElements.size() - 1];
                        ArrayList<String> minimized = new ArrayList<String>();
                        ChartPanel.this.minimizedResources.clear();
                        int i = 0;
                        while (i < uris.length) {
                            ChartPanelElement e = ChartPanel.this.chartElements.get(i);
                            Resource r = e.getResource();
                            if (r != null) {
                                uris[i] = graph.getURI(r);
                                if (e.isMinimized()) {
                                    minimized.add(uris[i]);
                                    ChartPanel.this.minimizedResources.add(r);
                                }
                            } else {
                                uris[i] = "";
                            }
                            ++i;
                        }
                        ChartPanel.this.settings.put(ChartPanel.CHARTS, uris);
                        if (!minimized.isEmpty()) {
                            ChartPanel.this.settings.put(ChartPanel.MINIMIZED_CHARTS, minimized.toArray(new String[minimized.size()]));
                        } else {
                            ChartPanel.this.settings.put(ChartPanel.MINIMIZED_CHARTS, new String[0]);
                        }
                        if (ChartPanel.this.vertical) {
                            ChartPanel.this.settings.put(ChartPanel.CHART_PANEL_ORIENTATION, ChartPanel.CHART_PANEL_VERTICAL);
                        } else {
                            ChartPanel.this.settings.put(ChartPanel.CHART_PANEL_ORIENTATION, ChartPanel.CHART_PANEL_HORIZONTAL);
                        }
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void setOrientation(String orientation) {
        this.vertical = CHART_PANEL_VERTICAL.equals(orientation);
        this.createContents();
    }

    public void removeChart(Resource chart) {
        ChartPanelElement element = this.charts.get(chart);
        this.chartElements.remove((Object)element);
        element.getParent().dispose();
        this.charts.remove(chart);
        this.minimizedResources.remove(chart);
        this.saveState();
        this.layout();
    }

    protected void setupDropTarget() {
        DropTarget target = new DropTarget((Control)this.sc, 2);
        target.setTransfer(new Transfer[]{LocalObjectTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){
            private int activeMargin = 20;
            private int moveAmount = 1;

            public void dragOver(DropTargetEvent event) {
                Point original = ChartPanel.this.sc.getOrigin();
                Point origin = ChartPanel.this.sc.getOrigin();
                Point pointer = ChartPanel.this.sc.toControl(event.x, event.y);
                Rectangle bounds = ChartPanel.this.sc.getBounds();
                if (pointer.y < this.activeMargin) {
                    origin.y -= this.moveAmount;
                } else if (bounds.height - pointer.y < this.activeMargin) {
                    origin.y += this.moveAmount;
                }
                if (pointer.x < this.activeMargin) {
                    origin.x -= this.moveAmount;
                } else if (bounds.width - pointer.x < this.activeMargin) {
                    origin.x += this.moveAmount;
                }
                if (origin != original) {
                    ChartPanel.this.sc.setOrigin(origin.x, origin.y);
                    ChartPanel.this.sc.redraw();
                }
            }
        });
        DropTarget target2 = new DropTarget((Control)this.body, 3);
        target2.setTransfer(new Transfer[]{LocalObjectTransfer.getTransfer()});
        target2.addDropListener((DropTargetListener)new ChartDropTarget(this.body, null, this));
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void addChart(Resource chartResource, ChartPanelElement element) {
        this.addChart(chartResource, element, true);
    }

    public void addChart(Resource chartResource, ChartPanelElement element, boolean layout) {
        int index;
        if (element == null) {
            element = this.chartElements.get(this.chartElements.size() - 1);
        }
        if ((index = this.chartElements.indexOf((Object)element)) >= 0) {
            ChartPanelElement newElement;
            ChartPanelElement e = this.chartElements.get(index);
            if (this.charts.containsKey(chartResource)) {
                newElement = this.charts.get(chartResource);
                int oldIndex = this.chartElements.indexOf((Object)newElement);
                if (((Object)((Object)newElement)).equals((Object)element) || oldIndex == index - 1) {
                    return;
                }
                Composite oldParent = newElement.getParent();
                newElement.setParent(e.getParent());
                oldParent.dispose();
                if (oldIndex < index) {
                    --index;
                }
                this.chartElements.remove((Object)newElement);
            } else {
                newElement = new ChartPanelElement(e.getParent(), this, chartResource, 0);
            }
            this.chartElements.add(index, newElement);
            this.charts.put(chartResource, newElement);
            int i = index + 1;
            while (i < this.chartElements.size()) {
                ElementContainer elementHolder;
                e = this.chartElements.get(i);
                if (i == this.chartElements.size() - 1) {
                    elementHolder = new ElementContainer(this.body, 0);
                    elementHolder.setBackground(new Color((Device)elementHolder.getDisplay(), 0, 0, 255));
                    elementHolder.setLayout((Layout)GridLayoutFactory.copyLayout((GridLayout)((GridLayout)e.getLayout())));
                    e.setParent(elementHolder);
                } else {
                    elementHolder = (ElementContainer)this.chartElements.get(i + 1).getParent();
                    e.setParent(elementHolder);
                }
                ++i;
            }
            this.layout();
            this.saveState();
        }
    }

    private void setChartExistingListener(final Resource chart) {
        Simantics.getSession().asyncRequest((Read)new Read<Boolean>(){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                return graph.hasStatement(chart);
            }
        }, (AsyncListener)new AsyncListener<Boolean>(){
            boolean disposed = false;

            public void execute(AsyncReadGraph graph, Boolean result) {
                if (result != null && !result.booleanValue() && ChartPanel.this.body != null && !ChartPanel.this.body.isDisposed()) {
                    ChartPanel.this.body.getDisplay().asyncExec((Runnable)new RunnableWithObject(chart){

                        public void run() {
                            ChartPanel.this.removeChart((Resource)this.getObject());
                        }
                    });
                    this.disposed = true;
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                throwable.printStackTrace();
            }

            public boolean isDisposed() {
                return !this.disposed && !ChartPanel.this.charts.containsKey(chart);
            }
        });
    }

    public ArrayList<ChartPanelElement> getElements() {
        return this.chartElements;
    }
}

