/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.state;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.simantics.DatabaseJob;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.Activator;

public class ExplorerStates {
    public static File explorerStateLocation() {
        return Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).toFile();
    }

    public static CompletableFuture<ExplorerState> scheduleRead(NodeContext root, StatePersistor persistor) {
        CompletableFuture<ExplorerState> result = new CompletableFuture<ExplorerState>();
        new ReaderJob(root, persistor, result).schedule();
        return result;
    }

    private static class ReaderJob
    extends DatabaseJob {
        private NodeContext root;
        private StatePersistor persistor;
        private CompletableFuture<ExplorerState> consumer;

        public ReaderJob(NodeContext root, StatePersistor persistor, CompletableFuture<ExplorerState> consumer) {
            super("Reading previous graph explorer state");
            this.root = root;
            this.persistor = persistor;
            this.consumer = consumer;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Loading persisted data", 1);
                ExplorerState state = this.persistor.deserialize(ExplorerStates.explorerStateLocation(), this.root);
                monitor.worked(1);
                this.consumer.complete(state);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

