/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.Collections;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest2;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.server.request.ServerSCLHandlerValueRequest;
import org.simantics.document.server.request.ServerSCLValueRequestBase;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.FindPossibleComponentTypeRequest;
import org.simantics.structural2.scl.ReadComponentTypeInterfaceRequest;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSCLValueRequest
extends ServerSCLValueRequestBase<CompilationContext> {
    private final Pair<Resource, Resource> componentTypeAndRoot;
    private final Resource literal;
    protected String possibleExpectedValueType;
    protected static Name PROPERTY_VALUE_CACHED = Name.create((String)"Document/All", (String)"propertyValueCached");

    private ServerSCLValueRequest(Pair<Resource, Resource> componentTypeAndRoot, Resource literal, String possibleExpectedValueType) {
        assert (literal != null);
        this.literal = literal;
        this.componentTypeAndRoot = componentTypeAndRoot;
        this.possibleExpectedValueType = possibleExpectedValueType;
    }

    public ServerSCLValueRequest(ReadGraph graph, Variable context) throws DatabaseException {
        this(ServerSCLValueRequest.getComponentTypeAndRoot(graph, context), context.getRepresents(graph), ServerSCLValueRequest.resolveExpectedValueType((ReadGraph)graph, (Resource)context.getPredicateResource(graph)));
    }

    public ServerSCLValueRequest(ReadGraph graph, Resource s, Resource o, Resource p) throws DatabaseException {
        this(ServerSCLValueRequest.getComponentTypeAndRoot(graph, s, o), o, ServerSCLValueRequest.resolveExpectedValueType((ReadGraph)graph, (Resource)p));
    }

    private static Pair<Resource, Resource> getComponentTypeAndRoot(ReadGraph graph, Variable property) throws DatabaseException {
        Resource type;
        Variable parent = property.getParent(graph);
        Resource represents = parent.getRepresents(graph);
        if (represents != null && (type = (Resource)graph.syncRequest((Read)new FindPossibleComponentTypeRequest(represents))) != null) {
            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(type));
            return Pair.make((Object)type, (Object)root);
        }
        parent = parent.getParent(graph);
        Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(property.getRepresents(graph)));
        return Pair.make((Object)parent.getType(graph), (Object)root);
    }

    public static Object compileAndEvaluate(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            Function1<Object, Object> exp = ServerSCLValueRequest.compile(graph, context);
            sclContext.put((Object)"graph", (Object)graph);
            Object object = exp.apply((Object)context);
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    public static Function1<Object, Object> compile(ReadGraph graph, Variable context) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ServerSCLValueRequest(graph, context), (Listener)TransientCacheListener.instance());
    }

    public static Function1<Object, Object> compile(ReadGraph graph, Resource s, Resource o, Resource p) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ServerSCLValueRequest(graph, s, o, p), (Listener)TransientCacheListener.instance());
    }

    protected String getExpressionText(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return (String)graph.getRelatedValue(this.literal, L0.SCLValue_expression, (Binding)Bindings.STRING);
    }

    protected RuntimeEnvironmentRequest2 getRuntimeEnvironmentRequest(Resource componentType, Resource indexRoot) {
        return new RuntimeEnvironmentRequest2(componentType, indexRoot){

            protected void fillEnvironmentSpecification(EnvironmentSpecification environmentSpecification) {
            }
        };
    }

    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
        return (CompilationContext)((Object)graph.syncRequest((Read)new UnaryRead<Pair<Resource, Resource>, CompilationContext>(this.componentTypeAndRoot){

            public CompilationContext perform(ReadGraph graph) throws DatabaseException {
                RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)ServerSCLValueRequest.this.getRuntimeEnvironmentRequest((Resource)((Pair)this.parameter).first, (Resource)((Pair)this.parameter).second));
                Map propertyMap = ((Pair)this.parameter).first != null ? (Map)graph.syncRequest((Read)new ReadComponentTypeInterfaceRequest((Resource)((Pair)this.parameter).first, runtimeEnvironment.getEnvironment()), (Listener)TransientCacheListener.instance()) : Collections.emptyMap();
                return new CompilationContext(runtimeEnvironment, propertyMap);
            }
        }));
    }

    protected Type getContextVariableType() {
        return VARIABLE;
    }

    private static Expression accessInputVariable(Environment environment, org.simantics.scl.compiler.elaboration.expressions.Variable contextVariable) {
        SCLValue variableParentFunction = environment.getValue(VARIABLE_PARENT);
        return new EApply((Expression)new EConstant(variableParentFunction), (Expression)new EApply((Expression)new EConstant(variableParentFunction), (Expression)new EVariable(contextVariable)));
    }

    protected static Expression getProperty(Environment environment, Expression variable, String propertyName, Type type) {
        return new EApply((Expression)new EConstant(environment.getValue(FROM_DYNAMIC), new Type[]{type}), (Expression)new EApply((Expression)new EConstant(environment.getValue(PROPERTY_VALUE_CACHED), new Type[]{Types.DYNAMIC}), new Expression[]{variable, new ELiteral((Constant)new StringConstant(propertyName))}));
    }

    protected static Expression getPropertyFlexible(Environment environment, Expression variable, String propertyName, Type type) {
        return ServerSCLValueRequest.makeTypeFlexible((Environment)environment, (Expression)ServerSCLValueRequest.getProperty(environment, variable, propertyName, type), (Type)type);
    }

    protected static Expression standardGetProperty(Environment environment, org.simantics.scl.compiler.elaboration.expressions.Variable contextVariable, String name, Type type) {
        return ServerSCLValueRequest.getPropertyFlexible(environment, ServerSCLValueRequest.accessInputVariable(environment, contextVariable), name, type);
    }

    protected Expression getVariableAccessExpression(ReadGraph graph, CompilationContext context, org.simantics.scl.compiler.elaboration.expressions.Variable contextVariable, String name) throws DatabaseException {
        ComponentTypeProperty property = context.propertyMap.get(name);
        if (property != null) {
            return ServerSCLValueRequest.standardGetProperty(context.runtimeEnvironment.getEnvironment(), contextVariable, name, (Type)(property.type == null ? Types.metaVar((Kind)Kinds.STAR) : property.type));
        }
        return this.getSpecialVariableAccessExpression(graph, context, contextVariable, name);
    }

    protected Expression getSpecialVariableAccessExpression(ReadGraph graph, CompilationContext context, org.simantics.scl.compiler.elaboration.expressions.Variable contextVariable, String name) throws DatabaseException {
        if (name.equals("input")) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return ServerSCLValueRequest.accessInputVariable(environment, contextVariable);
        }
        if (name.equals("self")) {
            return new EVariable(contextVariable);
        }
        return null;
    }

    protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
        return super.getExpectedType(graph, (AbstractExpressionCompilationContext)context);
    }

    public int hashCode() {
        return 31 * (31 * ((Object)((Object)this)).getClass().hashCode() + this.literal.hashCode()) + this.componentTypeAndRoot.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ServerSCLValueRequest other = (ServerSCLValueRequest)((Object)obj);
        return this.literal.equals(other.literal) && this.componentTypeAndRoot.equals(other.componentTypeAndRoot);
    }

    public static Function1<Object, Object> validate(ReadGraph graph, Variable context) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ServerSCLValueValidationRequest(graph, context), (Listener)TransientCacheListener.instance());
    }

    protected String getContextDescription(ReadGraph graph) throws DatabaseException {
        String uri;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Statement possibleOwner = graph.getPossibleStatement(this.literal, L0.IsOwnedBy);
        if (possibleOwner != null && (uri = graph.getPossibleURI(possibleOwner.getObject())) != null) {
            String propertyName = NameUtils.getSafeName((ReadGraph)graph, (Resource)graph.getInverse(possibleOwner.getPredicate()));
            return String.valueOf(uri) + "#" + propertyName;
        }
        return super.getContextDescription(graph);
    }

    public static class CompilationContext
    extends AbstractExpressionCompilationContext {
        public final Map<String, ComponentTypeProperty> propertyMap;

        public CompilationContext(RuntimeEnvironment runtimeEnvironment, Map<String, ComponentTypeProperty> propertyMap) {
            super(runtimeEnvironment);
            this.propertyMap = propertyMap;
        }
    }

    public static class ServerSCLValueValidationRequest
    extends ServerSCLValueRequest {
        private static final Logger LOGGER = LoggerFactory.getLogger(ServerSCLHandlerValueRequest.class);

        public ServerSCLValueValidationRequest(ReadGraph graph, Variable context) throws DatabaseException {
            super(graph, context);
        }

        @Override
        protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
            if (this.possibleExpectedValueType != null) {
                try {
                    return Environments.getType((Environment)context.runtimeEnvironment.getEnvironment(), (String)this.possibleExpectedValueType);
                }
                catch (SCLExpressionCompilationException e) {
                    LOGGER.error("Could not get type for " + String.valueOf(this.possibleExpectedValueType), (Throwable)e);
                }
            }
            return super.getExpectedType(graph, context);
        }
    }
}

