/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.client;

import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.service.ServiceActivityMonitor;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousSynchronizationJob
extends DatabaseJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContinuousSynchronizationJob.class);
    public static final String FAMILY = "ContinuousSynchronizationJob";
    private final ConcurrentMap<IExperiment, Job> currentSyncJobs;
    IExperiment experiment;

    public ContinuousSynchronizationJob(IExperiment experiment, ConcurrentMap<IExperiment, Job> currentSyncJobs) {
        super("Synchronization");
        this.experiment = experiment;
        this.currentSyncJobs = currentSyncJobs;
        this.setPriority(20);
        this.setSystem(false);
    }

    public boolean belongsTo(Object family) {
        if (FAMILY == family) {
            return true;
        }
        return super.belongsTo(family);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        try {
            LOGGER.debug("running ContinuousSynchronizationJob");
            monitor.beginTask("", -1);
            if (this.experiment.getState() != ExperimentState.DISPOSED) {
                this.experiment.refresh(Simantics.getSession());
            }
            LOGGER.debug("finished ContinuousSynchronizationJob");
            iStatus = Status.OK_STATUS;
        }
        catch (Throwable t) {
            Status status;
            try {
                LOGGER.error("Failed to refresh experiment", t);
                status = new Status(4, "org.simantics.structural.synchronization.client", "Failed to refresh experiment " + this.experiment + " with ID " + this.experiment.getIdentifier(), t);
            }
            catch (Throwable throwable) {
                ((ServiceActivityMonitor)Simantics.getSession().getService(ServiceActivityMonitor.class)).unregisterActivity(ContinuousSynchronizationJob.class);
                ConcurrentMap<IExperiment, Job> concurrentMap = this.currentSyncJobs;
                synchronized (concurrentMap) {
                    this.currentSyncJobs.remove(this.experiment);
                }
                monitor.done();
                throw throwable;
            }
            ((ServiceActivityMonitor)Simantics.getSession().getService(ServiceActivityMonitor.class)).unregisterActivity(ContinuousSynchronizationJob.class);
            ConcurrentMap<IExperiment, Job> concurrentMap = this.currentSyncJobs;
            synchronized (concurrentMap) {
                this.currentSyncJobs.remove(this.experiment);
            }
            monitor.done();
            return status;
        }
        ((ServiceActivityMonitor)Simantics.getSession().getService(ServiceActivityMonitor.class)).unregisterActivity(ContinuousSynchronizationJob.class);
        ConcurrentMap<IExperiment, Job> concurrentMap = this.currentSyncJobs;
        synchronized (concurrentMap) {
            this.currentSyncJobs.remove(this.experiment);
        }
        monitor.done();
        return iStatus;
    }
}

