/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hierarchical;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.grid.cell.AlternatingRowConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.swt.widgets.Display;

public class HierarchicalTreeAlternatingRowConfigLabelAccumulator
extends AlternatingRowConfigLabelAccumulator
implements ILayerListener,
ILayerCommandHandler<DisposeResourcesCommand> {
    private ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "HierarchicalTreeAlternatingRowConfigLabelAccumulator"));
    private Future<Void> future = null;
    private ConcurrentHashMap<Integer, String> rowLabelCache = new ConcurrentHashMap();

    public HierarchicalTreeAlternatingRowConfigLabelAccumulator(ILayer layer) {
        super(layer);
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        ILayerCell cell = this.layer.getCellByPosition(0, rowPosition);
        if (cell != null) {
            String label = this.rowLabelCache.get(cell.getOriginRowPosition());
            if (label == null) {
                if (this.future == null || this.future.isCancelled() || this.future.isDone()) {
                    this.calculateLabels();
                }
                if (rowPosition < 100) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    label = this.rowLabelCache.get(cell.getOriginRowPosition());
                    if (label != null) {
                        configLabels.addLabel(label);
                    }
                }
            } else {
                configLabels.addLabel(label);
            }
        }
    }

    public void calculateLabels() {
        this.future = this.executor.submit(() -> {
            String lastKnownLabel = "EVEN_BODY";
            this.rowLabelCache.put(0, lastKnownLabel);
            int row = 0;
            while (row < this.layer.getRowCount()) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                ILayerCell lastKnownCell = this.layer.getCellByPosition(0, row);
                if (lastKnownCell == null) break;
                row = lastKnownCell.getOriginRowPosition() + lastKnownCell.getRowSpan();
                lastKnownLabel = "ODD_BODY".equals(lastKnownLabel) ? "EVEN_BODY" : "ODD_BODY";
                this.rowLabelCache.put(row, lastKnownLabel);
            }
            Display.getDefault().asyncExec(() -> this.layer.fireLayerEvent(new VisualRefreshEvent(this.layer)));
            return null;
        });
    }

    public void clearCache() {
        if (this.future != null && !this.future.isCancelled() && !this.future.isDone()) {
            this.future.cancel(true);
            try {
                this.future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (CancellationException | ExecutionException exception) {
                // empty catch block
            }
        }
        this.rowLabelCache.clear();
        this.calculateLabels();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof RowStructuralChangeEvent && !(event instanceof RowResizeEvent) || event instanceof RowStructuralRefreshEvent) {
            this.clearCache();
        }
    }

    @Override
    public boolean doCommand(ILayer targetLayer, DisposeResourcesCommand command) {
        if (!this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
        return false;
    }

    @Override
    public Class<DisposeResourcesCommand> getCommandClass() {
        return DisposeResourcesCommand.class;
    }
}

