/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.common.request;

import java.util.Collection;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Adapt;
import org.simantics.db.common.request.HasTag;
import org.simantics.db.common.request.IsInstanceOfQuery;
import org.simantics.db.common.request.IsInstanceOfQuery2;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.ReadPossibleRelatedValue;
import org.simantics.db.common.request.ReadRelatedValue;
import org.simantics.db.common.request.ReadRelatedValue2;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.uri.ResourceToURI;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class Queries {
    public static AsyncRead<Resource> resource(String uri) {
        return new org.simantics.db.common.primitiverequest.Resource(uri);
    }

    public static Read<String> name(Resource resource) {
        return new ResourceRead<String>(resource){

            public String perform(ReadGraph graph) throws DatabaseException {
                return (String)graph.getRelatedValue(this.resource, Layer0.getInstance((ReadGraph)graph).HasName);
            }
        };
    }

    public static Read<String> safeName(Resource resource) {
        return new ResourceRead<String>(resource){

            public String perform(ReadGraph graph) throws DatabaseException {
                return NameUtils.getSafeName(graph, this.resource);
            }
        };
    }

    public static Read<String> name(final String uri) {
        return new UnaryRead<String, String>(uri){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource resource = graph.getResource(uri);
                return (String)graph.getRelatedValue(resource, Layer0.getInstance((ReadGraph)graph).HasName);
            }
        };
    }

    public static Read<String> uri(Resource resource) {
        return new ResourceToURI(resource);
    }

    public static Read<String> possibleUri(Resource resource) {
        return new ResourceToPossibleURI(resource);
    }

    public static <T> Read<T> adapt(Resource resource, Class<T> target) {
        return new Adapt<T>(resource, target);
    }

    public static <T> Read<T> adapt(Resource resource, Class<T> target, boolean allowNull) {
        return new Adapt<T>(resource, target, allowNull);
    }

    public static <T> Read<T> adapt(Resource resource, Class<T> target, boolean allowNull, boolean uniqueResult) {
        return new Adapt<T>(resource, target, allowNull, uniqueResult);
    }

    public static Read<Boolean> isInstanceOf(Resource resource, Resource type) {
        return new IsInstanceOfQuery(resource, type);
    }

    public static Read<Boolean> isInstanceOf(Resource resource, String type) {
        return new IsInstanceOfQuery2(resource, type);
    }

    public static <T> Read<T> getRelatedValue(Resource subject, Resource relation, Binding binding) {
        return new ReadRelatedValue(subject, relation, binding);
    }

    public static <T> Read<T> getRelatedValue(Resource subject, String relation, Binding binding) {
        return new ReadRelatedValue2(subject, relation, binding);
    }

    public static <T> Read<T> getPossibleRelatedValue(Resource subject, Resource relation, Binding binding) {
        return new ReadPossibleRelatedValue(subject, relation, binding);
    }

    public static Read<Boolean> hasTag(Resource subject, Resource tag) {
        return new HasTag(subject, tag);
    }

    public static ObjectsWithType objectsWithType(Resource subject, Resource subrelationOf, Resource instanceOf) {
        return new ObjectsWithType(subject, subrelationOf, instanceOf);
    }

    public static Read<Resource> possibleObjectWithType(Resource resource, Resource predicate, Resource type) {
        return new PossibleObjectWithType(resource, predicate, type);
    }

    public static Read<Resource> possibleObject(final Resource subject, final Resource predicate) {
        return new Read<Resource>(){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                return graph.getPossibleObject(subject, predicate);
            }
        };
    }

    public static Read<Collection<Resource>> objects(final Resource subject, final Resource predicate) {
        return new Read<Collection<Resource>>(){

            public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                return graph.getObjects(subject, predicate);
            }
        };
    }
}

