/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.container.DataContainer;
import org.simantics.databoard.container.DataContainers;
import org.simantics.databoard.container.FormatHandler;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.layer0.migration.MigratedImportResult;
import org.simantics.db.layer0.migration.MigrationUtils;
import org.simantics.db.layer0.util.DraftStatusBean;
import org.simantics.db.management.ISessionContext;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.modeling.ui.commandlog.ImportSharedOntologyCommand;
import org.simantics.modeling.ui.sharedontology.wizard.ImportPlan;
import org.simantics.modeling.ui.sharedontology.wizard.Preferences;
import org.simantics.modeling.ui.sharedontology.wizard.SharedOntologyImportPage;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.strings.EString;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.dialogs.InfoDialog;

public class SharedOntologyImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    ImportPlan importModel;

    private boolean readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        String recentPathsPref = store.getString("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return false;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return false;
        }
        this.importModel = new ImportPlan(ctx, recentImportPaths);
        this.importModel.project = project;
        this.importModel.selection = selection.getFirstElement();
        return true;
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("RECENT_SHARED_LIBRARY_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.recentLocations));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public SharedOntologyImportWizard() {
        this.setWindowTitle("Import Shared Library");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new SharedOntologyImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import Shared Library"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.recentLocations.addFirst(this.importModel.importLocation.getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.recentLocations);
            if (this.importModel.recentLocations.size() > 10) {
                this.importModel.recentLocations.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            final MigratedImportResult[] result = new MigratedImportResult[1];
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            Resource target = ResourceAdaptionUtils.toSingleResource((Object)SharedOntologyImportWizard.this.importModel.selection);
                            SharedOntologyImportWizard.this.importModel.sessionContext.getSession().markUndoPoint();
                            result[0] = SharedOntologyImportWizard.doImport(monitor, SharedOntologyImportWizard.this.importModel.importLocation, SharedOntologyImportWizard.this.importModel.sessionContext.getSession(), target);
                            if (Commands.isRecording()) {
                                Resource[] roots = result[0].roots.toArray(new Resource[result[0].roots.size()]);
                                Commands.record((Command)new ImportSharedOntologyCommand(roots, SharedOntologyImportWizard.this.importModel.importLocation.getAbsolutePath()));
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            if (result[0].hasMissingExternals()) {
                InfoDialog.open((Shell)this.getShell(), (String)"Missing Externals Created", (String)("The system was unable to find some of the external entities referenced by the imported material. Place-holders have been created for the missing entities.\nThe missing entities are:\n" + URIStringUtils.unescape((String)EString.implode((Collection)result[0].tgResult.missingExternals()))), (int)0x10000000);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (cause instanceof MissingDependencyException) {
                cp.setErrorMessage("Failed to import shared library due to missing dependencies.\n" + cause.getMessage());
                ErrorLogger.defaultLogError((String)("Shared Library " + this.importModel.importLocation + " import failed due to missing database dependencies. See exception for details."), (Throwable)cause);
                ExceptionUtils.showError((String)("Failed to import shared library due to missing dependencies.\n\n" + cause.getMessage()), null);
            } else {
                cp.setErrorMessage("Unexpected problem importing shared library.\nMessage: " + cause.getMessage());
                ErrorLogger.defaultLogError((String)("Shared Library " + this.importModel.importLocation + " import failed unexpectedly. See exception for details."), (Throwable)cause);
                ExceptionUtils.showError((String)("Unexpected problem importing shared library.\n\n" + cause.getMessage()), (Throwable)cause);
            }
            return false;
        }
        catch (InterruptedException e) {
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            cp.setErrorMessage("Import interrupted.\nMessage: " + e.getMessage());
            ErrorLogger.defaultLogError((String)("Shared Library " + this.importModel.importLocation + " import interrupted."), (Throwable)e);
            ExceptionUtils.showError((String)"Shared library import was interrupted.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static MigratedImportResult doImport(IProgressMonitor monitor, File modelFile, final Session session, Resource target) throws Exception {
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
        mon.beginTask("Loading shared library from disk", 1000);
        FormatHandler<MigratedImportResult> handler1 = new FormatHandler<MigratedImportResult>(){

            public Binding getBinding() {
                return TransferableGraph1.BINDING;
            }

            public MigratedImportResult process(DataContainer container) throws Exception {
                mon.worked(100);
                mon.setTaskName("Importing shared library into database");
                Variant draftStatus = (Variant)container.metadata.get(DraftStatusBean.EXTENSION_KEY);
                TransferableGraph1 tg = (TransferableGraph1)container.content.getValue();
                return MigrationUtils.importSharedOntology((IProgressMonitor)mon.newChild(850, 0), (Session)session, (TransferableGraph1)tg, (draftStatus == null ? 1 : 0) != 0);
            }
        };
        HashMap<String, 2> handlers = new HashMap<String, 2>();
        handlers.put("sharedLibrary:1", handler1);
        MigratedImportResult result = (MigratedImportResult)DataContainers.readFile((File)modelFile, handlers);
        mon.setTaskName("Postprocessing");
        mon.subTask("");
        mon.newChild(50).done();
        return result;
    }
}

