/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.pdf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.requests.Node;
import org.simantics.modeling.ui.pdf.DiagramPrinter;
import org.simantics.modeling.ui.pdf.PDFExportPage;
import org.simantics.modeling.ui.pdf.PDFExportPlan;
import org.simantics.modeling.ui.pdf.PdfException;
import org.simantics.modeling.ui.pdf.Preferences;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.FileUtils;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFDiagramExportWizard
extends Wizard
implements IExportWizard {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDFDiagramExportWizard.class);
    private static final int MAX_RECENT_EXPORT_PATHS = 10;
    PDFExportPlan exportPlan;

    private boolean readPreferences(PDFExportPlan toPlan) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.setDefault("diagram.export.pdf.includeDiagrams", true);
        store.setDefault("diagram.export.pdf.includeDoc", true);
        store.setDefault("diagram.export.pdf.includeComponentLevelDoc", true);
        store.setDefault("diagram.export.pdf.addPageNumbers", true);
        toPlan.recentLocations = Preferences.decodePaths(store.getString("diagram.export.pdf.path"));
        toPlan.fitContentToPageMargins = store.getBoolean("diagram.export.pdf.zoomToFit");
        toPlan.attachTG = store.getBoolean("diagram.export.pdf.attachTG");
        toPlan.includeDiagrams = store.getBoolean("diagram.export.pdf.includeDiagrams");
        toPlan.includeDocumentation = store.getBoolean("diagram.export.pdf.includeDoc");
        toPlan.includeComponentLevelDocumentation = store.getBoolean("diagram.export.pdf.includeComponentLevelDoc");
        toPlan.addPageNumbers = store.getBoolean("diagram.export.pdf.addPageNumbers");
        return true;
    }

    private void writePreferences(PDFExportPlan plan) throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling.ui");
        store.putValue("diagram.export.pdf.path", Preferences.encodePaths(plan.recentLocations));
        store.putValue("diagram.export.pdf.zoomToFit", String.valueOf(plan.fitContentToPageMargins));
        store.putValue("diagram.export.pdf.attachTG", String.valueOf(plan.attachTG));
        store.putValue("diagram.export.pdf.includeDiagrams", String.valueOf(plan.includeDiagrams));
        store.putValue("diagram.export.pdf.includeDoc", String.valueOf(plan.includeDocumentation));
        store.putValue("diagram.export.pdf.includeComponentLevelDoc", String.valueOf(plan.includeComponentLevelDocumentation));
        store.putValue("diagram.export.pdf.addPageNumbers", String.valueOf(plan.addPageNumbers));
        if (store.needsSaving()) {
            store.save();
        }
    }

    public PDFDiagramExportWizard() {
        this.setWindowTitle("Export Model to PDF");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        if (this.exportPlan != null) {
            this.addPage((IWizardPage)new PDFExportPage(this.exportPlan));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Export Model to PDF"));
        }
    }

    private NamedResource toNamedResource(ReadGraph graph, Resource r) throws DatabaseException {
        String name = NameLabelUtil.modalName((ReadGraph)graph, (Resource)r, (NameLabelMode)NameLabelMode.NAME_AND_LABEL);
        return new NamedResource(name, r);
    }

    public void init(IWorkbench workbench, final IStructuredSelection selection) {
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return;
        }
        IProject project = (IProject)ctx.getHint(ProjectKeys.KEY_PROJECT);
        if (project == null) {
            return;
        }
        this.exportPlan = new PDFExportPlan(ctx);
        this.exportPlan.project = project;
        this.exportPlan.initialSelection = selection;
        this.readPreferences(this.exportPlan);
        try {
            this.exportPlan.sessionContext.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Resource indexRoot;
                    HashSet<Resource> processed = new HashSet<Resource>();
                    ArrayList<NamedResource> models = new ArrayList<NamedResource>();
                    Collection ontologies = (Collection)Simantics.applySCL((String)"Simantics/SharedOntologies", (String)"traverseSharedOntologies", (ReadGraph)graph, (Object[])new Object[]{graph.getRootLibrary()});
                    for (Resource root : ontologies) {
                        if (!processed.add(root)) continue;
                        models.add(PDFDiagramExportWizard.this.toNamedResource(graph, root));
                    }
                    for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)PDFDiagramExportWizard.this.exportPlan.project.get(), Layer0.getInstance((ReadGraph)graph).ConsistsOf, SimulationResource.getInstance((ReadGraph)graph).Model))) {
                        if (!processed.add(model)) continue;
                        models.add(PDFDiagramExportWizard.this.toNamedResource(graph, model));
                    }
                    Collections.sort(models, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
                    PDFDiagramExportWizard.this.exportPlan.selectableModels.addAll(models);
                    Resource selected = ResourceAdaptionUtils.toSingleResource((Object)selection.getFirstElement());
                    Resource resource = indexRoot = selected != null ? (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(selected)) : null;
                    if (indexRoot != null) {
                        PDFDiagramExportWizard.this.exportPlan.initialModelSelection = PDFDiagramExportWizard.this.exportPlan.selection = PDFDiagramExportWizard.this.toNamedResource(graph, indexRoot);
                    }
                    if (PDFDiagramExportWizard.this.exportPlan.selection == null && !PDFDiagramExportWizard.this.exportPlan.selectableModels.isEmpty()) {
                        PDFDiagramExportWizard.this.exportPlan.selection = PDFDiagramExportWizard.this.exportPlan.selectableModels.get(0);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Failed to initialize diagram PDF export wizard input data.", (Throwable)e);
        }
    }

    public boolean performFinish() {
        Path target = this.exportPlan.exportLocation.toPath();
        if (Files.exists(target, LinkOption.NOFOLLOW_LINKS)) {
            boolean confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Overwrite", (String)("Are you sure you want to overwrite " + this.exportPlan.exportLocation));
            if (!confirmed) {
                return false;
            }
            try {
                FileUtils.delete((Path)target);
            }
            catch (IOException e) {
                ExceptionUtils.logAndShowError((Throwable)e);
                return false;
            }
        }
        Preferences.addFirstRemovingDuplicates(this.exportPlan.recentLocations, this.exportPlan.exportLocation.getAbsolutePath(), 10);
        try {
            this.writePreferences(this.exportPlan);
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        this.exportPlan.selectedNodes = this.exportPlan.nodes.depthFirstFlatten(this.exportPlan.selectedNodeSet::contains, Node.CASE_INSENSITIVE_COMPARATOR);
        long start = System.currentTimeMillis();
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    try {
                        DiagramPrinter.printToPdf(monitor, this.exportPlan, this.exportPlan.exportLocation.toString(), this.exportPlan.selectedNodes);
                    }
                    catch (PdfException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            ExceptionUtils.logAndShowError((Throwable)t);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        long end = System.currentTimeMillis();
        LOGGER.info("PDF export took " + (double)(end - start) * 0.001 + " seconds.");
        return true;
    }
}

