/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers.e4;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ToggleGridSnappingHandler {
    private static final String HANDLED_ITEM_ID = "org.simantics.modeling.ui.gridSnapToggle";
    @Inject
    private EModelService modelService;

    private void updateStateForPart(MPart part) {
        IWorkbenchPart wbPart = this.tryGetWorkbenchPart(part);
        if (wbPart != null) {
            MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)part);
            MToolItem item = (MToolItem)this.modelService.find(HANDLED_ITEM_ID, (MUIElement)win);
            ISnapAdvisor le = this.getAdvisor((IAdaptable)wbPart);
            if (item != null && le != null) {
                this.setToolItemState(item, le.isEnabled());
            }
        }
    }

    @Inject
    @Optional
    public void receiveActivePart(@Named(value="e4ActivePart") @Named(value="e4ActivePart") MPart activePart) {
        this.updateStateForPart(activePart);
    }

    @CanExecute
    public boolean canExecute(@Active MPart part) {
        return this.tryGetWorkbenchPart(part) instanceof DiagramEditor;
    }

    @Execute
    public void execute(@Optional MToolItem toolItem) {
        ISnapAdvisor advisor = this.getAdvisor();
        if (advisor != null) {
            boolean newValue = !advisor.isEnabled();
            advisor.setEnabled(newValue);
            if (toolItem != null) {
                this.setToolItemState(toolItem, newValue);
            }
        }
    }

    private void setToolItemState(MToolItem item, boolean snapToGrid) {
        item.setSelected(snapToGrid);
        item.setTooltip(snapToGrid ? "Turn Off Grid Snapping" : "Turn On Grid Snapping");
    }

    protected ISnapAdvisor getAdvisor() {
        DiagramEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        return this.getAdvisor((IAdaptable)editor);
    }

    protected ISnapAdvisor getAdvisor(IAdaptable editor) {
        ICanvasContext ctx = (ICanvasContext)editor.getAdapter(ICanvasContext.class);
        if (ctx == null) {
            return null;
        }
        ISnapAdvisor advisor = (ISnapAdvisor)ctx.getDefaultHintContext().getHint(DiagramHints.SNAP_ADVISOR);
        return advisor;
    }

    protected DiagramEditor getEditor() {
        IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)editorPart;
            return editor;
        }
        return null;
    }

    private IWorkbenchPart tryGetWorkbenchPart(MPart part) {
        if (part == null) {
            return null;
        }
        Object obj = part.getObject();
        if (obj instanceof CompatibilityEditor) {
            CompatibilityEditor editor = (CompatibilityEditor)obj;
            return editor.getPart();
        }
        if (obj instanceof IWorkbenchPart) {
            return (IWorkbenchPart)obj;
        }
        return null;
    }
}

