/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.CopyHandler2;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerData;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeViewerSection;
import org.simantics.modeling.ui.componentTypeEditor.LiftPropertiesDialog;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.modeling.ui.componentTypeEditor.SetTypesDialog;
import org.simantics.modeling.ui.componentTypeEditor.StringWriter;
import org.simantics.modeling.userComponent.ComponentTypeCommands;
import org.simantics.modeling.utils.ComponentTypePropertiesResult;
import org.simantics.modeling.utils.ComponentTypeViewerPropertyInfo;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPropertiesSection
implements ComponentTypeViewerSection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationPropertiesSection.class);
    private static final String[] COLUMN_NAMES = new String[]{Messages.ConfigurationPropertiesSection_Name, Messages.ConfigurationPropertiesSection_Type, Messages.ConfigurationPropertiesSection_DefaultValue, Messages.ConfigurationPropertiesSection_Unit, Messages.ConfigurationPropertiesSection_Range, Messages.ConfigurationPropertiesSection_Label, Messages.ConfigurationPropertiesSection_Description};
    private static final int[] COLUMN_LENGTHS = new int[]{120, 100, 100, 50, 100, 100, 100};
    private static final int[] COLUMN_WEIGHTS;
    private static final int[] IMMUTABLE_COLUMNS_WITH_IMMUTABLE_RELATION;
    ComponentTypeViewerData data;
    Table table;
    TableColumn[] columns;
    TableEditor editor;
    Button newProperty;
    Button removeProperty;
    Button liftProperties;
    boolean hasTypes = false;
    Button setTypes;
    Section section;

    static {
        int[] nArray = new int[7];
        nArray[5] = 50;
        nArray[6] = 100;
        COLUMN_WEIGHTS = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 5;
        nArray2[5] = 6;
        IMMUTABLE_COLUMNS_WITH_IMMUTABLE_RELATION = nArray2;
    }

    public ConfigurationPropertiesSection(final ComponentTypeViewerData data) {
        this.data = data;
        final FormToolkit tk = data.tk;
        Form form = data.form;
        this.section = tk.createSection(form.getBody(), 320);
        this.section.setLayout((Layout)new FillLayout());
        this.section.setText(Messages.ConfigurationPropertiesSection_ConfigurationProperties);
        Composite sectionBody = tk.createComposite((Composite)this.section);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody);
        this.section.setClient((Control)sectionBody);
        Composite tableComposite = tk.createComposite(sectionBody);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tcl = new TableColumnLayout();
        tableComposite.setLayout((Layout)tcl);
        this.table = tk.createTable(tableComposite, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.columns = new TableColumn[COLUMN_NAMES.length];
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TableColumn column;
            this.columns[i] = column = new TableColumn(this.table, 0);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(COLUMN_WEIGHTS[i], COLUMN_LENGTHS[i], true));
            column.setText(COLUMN_NAMES[i]);
            ++i;
        }
        this.editor = new TableEditor(this.table);
        this.editor.grabHorizontal = true;
        this.editor.grabVertical = true;
        this.editor.horizontalAlignment = 16384;
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Control oldEditor = ConfigurationPropertiesSection.this.editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if (data.readOnly) {
                    return;
                }
                Rectangle tableBounds = ConfigurationPropertiesSection.this.table.getClientArea();
                int rx = e.x - tableBounds.x;
                int ry = e.y - tableBounds.y;
                TableItem selectedItem = null;
                int selectedColumn = -1;
                Rectangle selectedItemBounds = null;
                TableItem[] tableItemArray = ConfigurationPropertiesSection.this.table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    int column = 0;
                    while (column < COLUMN_NAMES.length) {
                        Rectangle bounds = item.getBounds(column);
                        if (bounds.contains(rx, ry)) {
                            selectedItemBounds = bounds;
                            selectedItem = item;
                            selectedColumn = column;
                            break;
                        }
                        ++column;
                    }
                    ++n2;
                }
                if (selectedItem == null) {
                    return;
                }
                int column = selectedColumn;
                final ComponentTypeViewerPropertyInfo propertyInfo = (ComponentTypeViewerPropertyInfo)selectedItem.getData();
                final Resource resource = propertyInfo.resource;
                switch (column) {
                    case 0: {
                        data.editName(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, column, ComponentTypeViewerData.PROPERTY_NAME_PATTERN);
                        break;
                    }
                    case 1: {
                        data.editType(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, column, selectedItem.getText(4), true);
                        break;
                    }
                    case 2: {
                        data.editValue(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, column, data.readOnly ? null : new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                graph.markUndoPoint();
                                ComponentTypeCommands.setDefaultValue((WriteGraph)graph, (Resource)data.componentType, (Resource)propertyInfo.resource, (String)newValue);
                            }
                        }, null);
                        break;
                    }
                    case 3: {
                        data.editUnit(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, column);
                        break;
                    }
                    case 4: {
                        data.editRange(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, selectedItemBounds, column);
                        break;
                    }
                    case 5: {
                        data.editValue(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, column, propertyInfo.immutable ? null : new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                graph.markUndoPoint();
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setLabel((WriteGraph)graph, (Resource)resource, (String)value);
                            }
                        }, null);
                        break;
                    }
                    case 6: {
                        data.editMultilineText(ConfigurationPropertiesSection.this.table, ConfigurationPropertiesSection.this.editor, propertyInfo, selectedItem, selectedItemBounds, column, new StringWriter(){

                            @Override
                            public void perform(WriteGraph graph, String newValue) throws DatabaseException {
                                graph.markUndoPoint();
                                String value = newValue.isEmpty() ? null : newValue;
                                ComponentTypeCommands.setDescription((WriteGraph)graph, (Resource)resource, (String)value);
                            }
                        });
                    }
                }
            }
        });
        Composite buttons = tk.createComposite(sectionBody);
        GridDataFactory.fillDefaults().applyTo((Control)buttons);
        GridLayoutFactory.fillDefaults().applyTo(buttons);
        this.newProperty = tk.createButton(buttons, Messages.ConfigurationPropertiesSection_NewProperty, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.newProperty);
        this.removeProperty = tk.createButton(buttons, Messages.ConfigurationPropertiesSection_RemoveProperty, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeProperty);
        this.liftProperties = tk.createButton(buttons, Messages.ConfigurationPropertiesSection_LiftProperties, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.liftProperties);
        boolean bl = this.hasTypes = !this.getTypes().isEmpty();
        if (this.hasTypes) {
            this.setTypes = tk.createButton(buttons, Messages.ConfigurationPropertiesSection_AssignTypes, 8);
            GridDataFactory.fillDefaults().applyTo((Control)this.setTypes);
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] sel;
                TableItem[] tableItemArray = sel = ConfigurationPropertiesSection.this.table.getSelection();
                int n = sel.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ComponentTypeViewerPropertyInfo pi = (ComponentTypeViewerPropertyInfo)item.getData();
                    if (pi.immutable) {
                        ConfigurationPropertiesSection.this.removeProperty.setEnabled(false);
                        return;
                    }
                    ++n2;
                }
                ConfigurationPropertiesSection.this.removeProperty.setEnabled(true);
            }
        });
        this.newProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationPropertiesSection.this.editor.getEditor() != null) {
                    ConfigurationPropertiesSection.this.editor.getEditor().dispose();
                }
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        ComponentTypeCommands.createPropertyWithDefaults((WriteGraph)graph, (Resource)data.componentType);
                    }
                });
            }
        });
        this.removeProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationPropertiesSection.this.editor.getEditor() != null) {
                    ConfigurationPropertiesSection.this.editor.getEditor().dispose();
                }
                final ArrayList<Resource> propertiesToBeRemoved = new ArrayList<Resource>();
                TableItem[] tableItemArray = ConfigurationPropertiesSection.this.table.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    ComponentTypeViewerPropertyInfo info = (ComponentTypeViewerPropertyInfo)item.getData();
                    if (!info.immutable) {
                        propertiesToBeRemoved.add(info.resource);
                    }
                    ++n2;
                }
                if (!propertiesToBeRemoved.isEmpty()) {
                    Simantics.getSession().async((WriteInterface)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            for (Resource property : propertiesToBeRemoved) {
                                ComponentTypeCommands.removeProperty((WriteGraph)graph, (Resource)data.componentType, (Resource)property);
                            }
                        }
                    });
                }
            }
        });
        this.liftProperties.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ConfigurationPropertiesSection.this.editor.getEditor() != null) {
                    ConfigurationPropertiesSection.this.editor.getEditor().dispose();
                }
                try {
                    Map map = (Map)Simantics.sync((ReadInterface)new UniqueRead<Map<LiftPropertiesDialog.LiftedProperty, Pair<String, ImageDescriptor>>>(){

                        public Map<LiftPropertiesDialog.LiftedProperty, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                            HashMap<LiftPropertiesDialog.LiftedProperty, Pair<String, ImageDescriptor>> map = new HashMap<LiftPropertiesDialog.LiftedProperty, Pair<String, ImageDescriptor>>();
                            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                            StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                            SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
                            Resource composite = graph.getPossibleObject(data.componentType, STR.IsDefinedBy);
                            if (composite == null) {
                                return map;
                            }
                            HashSet<String> existing = new HashSet<String>();
                            for (Resource predicate : graph.getObjects(data.componentType, L0.DomainOf)) {
                                if (!graph.isSubrelationOf(predicate, L0.HasProperty)) continue;
                                existing.add(NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate));
                            }
                            for (Resource component : (Collection)graph.syncRequest((Read)new ObjectsWithType(composite, L0.ConsistsOf, STR.Component))) {
                                Resource type = graph.getPossibleType(component, STR.Component);
                                if (type == null) continue;
                                String componentName = NameUtils.getSafeName((ReadGraph)graph, (Resource)component);
                                for (Resource predicate : graph.getPredicates(component)) {
                                    String predicateName;
                                    Boolean canBeLifted;
                                    if (!graph.isSubrelationOf(predicate, L0.HasProperty) || graph.hasStatement(predicate, SEL.IsShownUnder) || !graph.hasStatement(predicate, SEL.HasStandardPropertyInfo) || (canBeLifted = (Boolean)graph.getPossibleRelatedValue(predicate, SEL.canBeLifted, (Binding)Bindings.BOOLEAN)) != null && !canBeLifted.booleanValue() || existing.contains(predicateName = NameUtils.getSafeName((ReadGraph)graph, (Resource)predicate))) continue;
                                    String name = String.valueOf(componentName) + " " + predicateName;
                                    map.put(new LiftPropertiesDialog.LiftedProperty(component, type, predicate), (Pair<String, ImageDescriptor>)new Pair((Object)name, null));
                                }
                            }
                            return map;
                        }
                    });
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    LiftPropertiesDialog dialog = new LiftPropertiesDialog(shell, map, Messages.ConfigurationPropertiesSection_SelectPropertiesToLift){

                        @Override
                        protected IDialogSettings getBaseDialogSettings() {
                            return Activator.getDefault().getDialogSettings();
                        }
                    };
                    if (dialog.open() == 0) {
                        final Collection _result = dialog.getResultT();
                        final boolean mapProperties = dialog.getMapProperties();
                        if (!_result.isEmpty()) {
                            Simantics.getSession().async((WriteInterface)new WriteRequest(){

                                public Resource findAssertion(ReadGraph graph, Resource sourceType, Resource predicate) throws DatabaseException {
                                    Collection ass = graph.getAssertedObjects(sourceType, predicate);
                                    if (ass.size() == 1) {
                                        return (Resource)ass.iterator().next();
                                    }
                                    return null;
                                }

                                public void processSubs(ReadGraph graph, Resource predicate, Resource component, Resource componentType, List<LiftPropertiesDialog.LiftedProperty> result, List<Resource> properties, List<Resource> assertions) throws DatabaseException {
                                    SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
                                    for (Resource sub : graph.getObjects(predicate, SEL.UnderOf)) {
                                        Resource ass = this.findAssertion(graph, componentType, sub);
                                        if (ass == null) continue;
                                        result.add(new LiftPropertiesDialog.LiftedProperty(component, componentType, sub));
                                        properties.add(sub);
                                        assertions.add(ass);
                                        this.processSubs(graph, sub, component, componentType, result, properties, assertions);
                                    }
                                }

                                public void perform(WriteGraph graph) throws DatabaseException {
                                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                    graph.markUndoPoint();
                                    ArrayList<Resource> properties = new ArrayList<Resource>();
                                    ArrayList<Resource> assertions = new ArrayList<Resource>();
                                    ArrayList<LiftPropertiesDialog.LiftedProperty> result = new ArrayList<LiftPropertiesDialog.LiftedProperty>();
                                    for (LiftPropertiesDialog.LiftedProperty p : _result) {
                                        Resource ass = this.findAssertion((ReadGraph)graph, p.getComponentType(), p.getPredicate());
                                        if (ass == null) continue;
                                        result.add(p);
                                        properties.add(p.getPredicate());
                                        assertions.add(ass);
                                        this.processSubs((ReadGraph)graph, p.getPredicate(), p.getComponent(), p.getComponentType(), result, properties, assertions);
                                    }
                                    CopyHandler2 ch = Layer0Utils.getPossibleCopyHandler((ReadGraph)graph, properties);
                                    Collection copies = Layer0Utils.copyTo((WriteGraph)graph, (Resource)data.componentType, null, (CopyHandler)ch, null);
                                    int index = 0;
                                    for (Resource copy : copies) {
                                        Resource ass = (Resource)assertions.get(index);
                                        LiftPropertiesDialog.LiftedProperty p = (LiftPropertiesDialog.LiftedProperty)((Object)result.get(index));
                                        Collection copyAss = Layer0Utils.copyTo((WriteGraph)graph, null, (Resource)ass);
                                        if (copyAss.size() == 1) {
                                            graph.deny(copy, L0.HasDomain);
                                            graph.claim(data.componentType, L0.DomainOf, copy);
                                            Layer0Utils.assert_((WriteGraph)graph, (Resource)data.componentType, (Resource)copy, (Resource)((Resource)copyAss.iterator().next()));
                                            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                                            graph.addMetadata((Metadata)cm.add("Lifted property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy) + " into " + NameUtils.getSafeName((ReadGraph)graph, (Resource)data.componentType)));
                                        }
                                        if (mapProperties) {
                                            Variable v = Variables.getVariable((ReadGraph)graph, (Resource)p.getComponent());
                                            Variable property = v.getProperty((ReadGraph)graph, p.getPredicate());
                                            Variable displayValue = property.getProperty((ReadGraph)graph, "HasDisplayValue");
                                            displayValue.setValue(graph, (Object)("=" + NameUtils.getSafeName((ReadGraph)graph, (Resource)p.getPredicate())), (Binding)Bindings.STRING);
                                        }
                                        ++index;
                                    }
                                }
                            });
                        }
                    }
                }
                catch (DatabaseException e1) {
                    LOGGER.error("Lifting properties failed", (Throwable)e1);
                    return;
                }
            }
        });
        if (this.hasTypes) {
            this.setTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] result;
                    if (ConfigurationPropertiesSection.this.editor.getEditor() != null) {
                        ConfigurationPropertiesSection.this.editor.getEditor().dispose();
                    }
                    final ArrayList<Resource> propertiesToSet = new ArrayList<Resource>();
                    TableItem[] tableItemArray = ConfigurationPropertiesSection.this.table.getSelection();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        propertiesToSet.add(((ComponentTypeViewerPropertyInfo)item.getData()).resource);
                        ++n2;
                    }
                    if (propertiesToSet.size() != 1) {
                        return;
                    }
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    SetTypesDialog page = new SetTypesDialog(shell, ConfigurationPropertiesSection.this.getTypes(), Messages.ConfigurationPropertiesSection_SelectUserTypesForProp);
                    if (page.open() == 0 && (result = page.getResult()) != null && result.length > 0) {
                        Simantics.getSession().async((WriteInterface)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                Object[] objectArray = result;
                                int n = result.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object type = objectArray[n2];
                                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                    graph.claim((Resource)propertiesToSet.get(0), L0.InstanceOf, null, (Resource)type);
                                    ++n2;
                                }
                            }
                        });
                    }
                }
            });
        }
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                tk.dispose();
            }
        });
    }

    @Override
    public void update(ComponentTypePropertiesResult result) {
        if (this.table.isDisposed()) {
            return;
        }
        HashSet<ComponentTypeViewerPropertyInfo> selected = new HashSet<ComponentTypeViewerPropertyInfo>();
        ArrayList<TableItem> selectedItems = new ArrayList<TableItem>(selected.size());
        int[] nArray = this.table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableItem item = this.table.getItem(i);
            selected.add((ComponentTypeViewerPropertyInfo)item.getData());
            ++n2;
        }
        int topIndex = this.table.getTopIndex();
        this.table.removeAll();
        if (this.editor.getEditor() != null) {
            this.editor.getEditor().dispose();
        }
        for (ComponentTypeViewerPropertyInfo info : result.getProperties()) {
            Color fg;
            boolean immutable = result.isImmutable() || info.immutable;
            Color color = fg = immutable ? this.table.getDisplay().getSystemColor(16) : null;
            if (info.sectionSpecificData != null) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, info.name);
            item.setText(1, info.type);
            item.setText(2, info.defaultValue);
            item.setText(3, info.unitString());
            item.setText(4, info.rangeString());
            item.setText(5, info.label);
            item.setText(6, info.description);
            int[] nArray2 = IMMUTABLE_COLUMNS_WITH_IMMUTABLE_RELATION;
            int n3 = IMMUTABLE_COLUMNS_WITH_IMMUTABLE_RELATION.length;
            int n4 = 0;
            while (n4 < n3) {
                int columnIndex = nArray2[n4];
                item.setForeground(columnIndex, fg);
                ++n4;
            }
            item.setData((Object)info);
            if (!selected.contains(info)) continue;
            selectedItems.add(item);
        }
        this.table.setTopIndex(topIndex);
        this.table.setSelection(selectedItems.toArray(new TableItem[selectedItems.size()]));
        this.table.redraw();
    }

    private Map<Resource, Pair<String, ImageDescriptor>> getTypes() {
        try {
            return (Map)Simantics.getSession().syncRequest((Read)new UniqueRead<Map<Resource, Pair<String, ImageDescriptor>>>(){

                public Map<Resource, Pair<String, ImageDescriptor>> perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(ConfigurationPropertiesSection.this.data.componentType));
                    Instances query = (Instances)graph.adapt(STR.UserDefinedProperty, Instances.class);
                    Collection types = query.find(graph, indexRoot);
                    HashMap<Resource, Pair<String, ImageDescriptor>> result = new HashMap<Resource, Pair<String, ImageDescriptor>>();
                    for (Resource type : types) {
                        String name = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)type);
                        result.put(type, (Pair<String, ImageDescriptor>)new Pair((Object)name, null));
                    }
                    return result;
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Finding UserDefinedProperties failed.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        boolean e = !readOnly;
        this.newProperty.setEnabled(e);
        this.removeProperty.setEnabled(e);
        this.liftProperties.setEnabled(e);
    }

    @Override
    public Section getSection() {
        return this.section;
    }

    @Override
    public double getPriority() {
        return 0.0;
    }

    @Override
    public Object getSectionSpecificData(ReadGraph graph, ComponentTypeViewerPropertyInfo info) throws DatabaseException {
        return null;
    }

    @Override
    public double getDataPriority() {
        return 0.0;
    }
}

