/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.actions;

import gnu.trove.map.hash.THashMap;
import java.awt.Graphics2D;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class MoveAction
implements IAction {
    protected RouteGraph rg;
    protected Object target;
    protected RouteGraph movedRg;

    public MoveAction(RouteGraph rg, Object target) {
        this.rg = rg;
        this.target = target;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double x, double y) {
        THashMap map = new THashMap();
        this.movedRg = this.rg.copy((THashMap<Object, Object>)map);
        this.move(this.movedRg, map.get(this.target), x, y);
        renderer.render(g, this.movedRg);
    }

    public RouteGraph getRouteGraph() {
        return this.movedRg == null ? this.rg : this.movedRg;
    }

    public Object getTarget() {
        return this.target;
    }

    public void finish(double x, double y) {
        this.move(this.rg, this.target, x, y);
        this.movedRg = null;
    }

    protected void move(RouteGraph rg, Object target, double x, double y) {
        MoveAction.moveTarget(rg, target, x, y);
    }

    private static void moveTarget(RouteGraph rg, Object target, double x, double y) {
        if (target instanceof RouteLine) {
            RouteLine line = (RouteLine)target;
            rg.setLocation(line, x, y);
        } else if (target instanceof RouteTerminal) {
            RouteTerminal terminal = (RouteTerminal)target;
            rg.setLocation(terminal, x, y);
        } else if (target instanceof RouteLink) {
            RouteLink link = (RouteLink)target;
            RouteLine a = link.getA();
            RouteLine b = link.getB();
            rg.setLocation(a, x, y);
            rg.setLocation(b, x, y);
        }
    }

    public static MoveAction create(RouteGraph rg, double x, double y) {
        return MoveAction.create(rg, x, y, 1.0);
    }

    public static MoveAction create(RouteGraph rg, double x, double y, double tolerance) {
        Object target = rg.pick(x, y, tolerance);
        if (target == null) {
            return null;
        }
        return new MoveAction(rg, target);
    }

    public static MoveAction create(RouteGraph rg, double x, double y, double tolerance, TargetFilter filter) {
        Object target = rg.pick(x, y, tolerance);
        if (target != null && (filter == null || filter.accept(target))) {
            return new MoveAction(rg, target);
        }
        return null;
    }

    public static interface TargetFilter {
        public boolean accept(Object var1);
    }
}

