/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.charts.Activator;
import org.simantics.charts.internal.VariableUtils;
import org.simantics.charts.ui.AddVariableToChartAction;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.PropertyVariablesImpl;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class SubscriptionDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        Resource subscription = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (subscription == null) {
            return null;
        }
        Resource targetModel = (Resource)g.syncRequest((Read)new PossibleModel(subscription));
        if (source instanceof RVI) {
            RVI rvi = (RVI)source;
            List<VariableReference> refs = Collections.singletonList(new VariableReference(rvi, VariableUtils.getDatatype(g, targetModel, rvi), null));
            return this.addSubscriptions(g, subscription, refs, Collections.emptySet());
        }
        List vars = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (!vars.isEmpty()) {
            List references = (List)g.syncRequest(VariableReferences.toReferences((Resource)targetModel, (List)(vars = PropertyVariablesImpl.resolve((ReadGraph)g, (List)vars))));
            if (!references.isEmpty()) {
                return this.addSubscriptions(g, subscription, references, Collections.emptySet());
            }
        } else {
            List srcs = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
            HashSet<Resource> movedItems = new HashSet<Resource>();
            for (Resource src : srcs) {
                Resource model;
                if (!g.isInstanceOf(src, MOD.Subscription_Item) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)g.syncRequest((Read)new PossibleModel(src))))) continue;
                movedItems.add(src);
            }
            if (!movedItems.isEmpty()) {
                return this.addSubscriptions(g, subscription, Collections.emptyList(), movedItems);
            }
        }
        if (source instanceof String) {
            return this.handleStringDrop(g, subscription, targetModel, (String)source);
        }
        return null;
    }

    private Runnable handleStringDrop(ReadGraph graph, Resource subscription, Resource targetModel, String source) throws DatabaseException {
        try {
            List<VariableReference> refs = VariableUtils.getVariableReferencesFromString(graph, targetModel, source);
            return refs != null && !refs.isEmpty() ? this.addSubscriptions(graph, subscription, refs, Collections.emptySet()) : null;
        }
        catch (DatabaseException databaseException) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.simantics.charts", String.valueOf(this.getClass().getSimpleName()) + ": Unrecognized String input: " + source));
            return null;
        }
    }

    private Runnable addSubscriptions(ReadGraph graph, final Resource subscription, List<VariableReference> references, final Set<Resource> movedSubscriptionItems) throws DatabaseException {
        AddVariableToChartAction action = new AddVariableToChartAction(null, subscription, references).init(graph);
        return () -> {
            action.run();
            if (!movedSubscriptionItems.isEmpty()) {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        for (Resource item : movedSubscriptionItems) {
                            graph.deny(item, L0.PartOf);
                            graph.claim(subscription, L0.ConsistsOf, item);
                        }
                    }
                }, e -> {
                    if (e != null) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                });
            }
        };
    }
}

