/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.xmile.expressionParser;

import org.simantics.sysdyn.xmile.expressionParser.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = 1L;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initialise(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    private static String initialise(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        String eol = System.getProperty("line.separator", "\n");
        StringBuffer expected = new StringBuffer();
        int maxSize = 0;
        int i = 0;
        while (i < expectedTokenSequences.length) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            int j = 0;
            while (j < expectedTokenSequences[i].length) {
                expected.append(tokenImage[expectedTokenSequences[i][j]]).append(' ');
                ++j;
            }
            if (expectedTokenSequences[i][expectedTokenSequences[i].length - 1] != 0) {
                expected.append("...");
            }
            expected.append(eol).append("    ");
            ++i;
        }
        String retval = "Encountered \"";
        Token tok = currentToken.next;
        int i2 = 0;
        while (i2 < maxSize) {
            if (i2 != 0) {
                retval = String.valueOf(retval) + " ";
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval) + tokenImage[0];
                break;
            }
            retval = String.valueOf(retval) + " " + tokenImage[tok.kind];
            retval = String.valueOf(retval) + " \"";
            retval = String.valueOf(retval) + ParseException.add_escapes(tok.image);
            retval = String.valueOf(retval) + " \"";
            tok = tok.next;
            ++i2;
        }
        retval = String.valueOf(retval) + "\" at line " + currentToken.next.beginLine + ", column " + currentToken.next.beginColumn;
        retval = String.valueOf(retval) + "." + eol;
        retval = expectedTokenSequences.length == 1 ? String.valueOf(retval) + "Was expecting:" + eol + "    " : String.valueOf(retval) + "Was expecting one of:" + eol + "    ";
        retval = String.valueOf(retval) + expected.toString();
        return retval;
    }

    static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

