/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.model;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.db.Resource;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.sysdyn.modelExport.SysdynModelExporter;
import org.simantics.sysdyn.ui.wizards.Preferences;
import org.simantics.sysdyn.ui.wizards.model.SysdynExportModel;
import org.simantics.sysdyn.ui.wizards.model.SysdynModelExportPage;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class SysdynModelExportWizard
extends Wizard
implements IExportWizard {
    private static final int MAX_RECENT_EXPORT_PATHS = 10;
    private SysdynExportModel exportModel;
    private Deque<String> recentExportPaths;
    private boolean overwrite;

    public SysdynModelExportWizard() {
        this.setWindowTitle("Export Sysdyn Model");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences();
        this.exportModel = new SysdynExportModel(selection.getFirstElement(), this.overwrite);
    }

    public void addPages() {
        super.addPages();
        if (this.exportModel != null) {
            this.addPage((IWizardPage)new SysdynModelExportPage(this.exportModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Export Sysdyn Model"));
        }
    }

    public boolean performFinish() {
        try {
            this.recentExportPaths.addFirst(this.exportModel.getExportLocation().getAbsolutePath());
            Preferences.removeDuplicates(this.recentExportPaths);
            if (this.recentExportPaths.size() > 10) {
                this.recentExportPaths.pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        File output = this.exportModel.getExportLocation();
        if (output.exists()) {
            boolean ok;
            if (!this.exportModel.getOverwrite() && !(ok = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Overwrite", (String)("A file by the name " + output.getAbsolutePath() + " already exists.\n\nDo you want to overwrite?")))) {
                return false;
            }
            if (!output.delete()) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete Problem", (String)("Could not overwrite previously existing file " + output));
                return false;
            }
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SysdynModelExporter.exportModel((IProgressMonitor)monitor, (Resource)SysdynModelExportWizard.this.exportModel.getModel().getResource(), (File)SysdynModelExportWizard.this.exportModel.getExportLocation(), (String)SysdynModelExportWizard.this.exportModel.getDescription(), (boolean)SysdynModelExportWizard.this.exportModel.getDependencies());
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            if (t instanceof IOException) {
                ErrorLogger.defaultLogError((String)"An I/O problem occurred while exporting the model. See exception for details.", (Throwable)t);
                cp.setErrorMessage("An I/O problem occurred while exporting the model.\nMessage: " + t.getMessage());
            } else {
                ErrorLogger.defaultLogError((String)"Unexpected exception while exporting the model. See exception for details.", (Throwable)t);
                cp.setErrorMessage("Unexpected exception while exporting the model. See error log for details.\nMessage: " + t.getMessage());
            }
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
        return true;
    }

    private void readPreferences() {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.sysdyn.ui");
        String recentPathsPref = store.getString("RECENT_MODEL_EXPORT_LOCATIONS");
        this.recentExportPaths = Preferences.decodePaths(recentPathsPref);
        this.overwrite = store.getBoolean("MODEL_EXPORT_OVERWRITE");
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.sysdyn.ui");
        store.putValue("RECENT_MODEL_EXPORT_LOCATIONS", Preferences.encodePaths(this.recentExportPaths));
        store.setValue("MODEL_EXPORT_OVERWRITE", this.exportModel.getOverwrite());
        if (store.needsSaving()) {
            store.save();
        }
    }
}

