/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.viewUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.request.PossibleActiveVariableFromVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingUtils;
import org.simantics.sysdyn.Functions;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.ui.trend.PinTrend;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class SysdynDatasetSelectionListener
implements ISelectionListener {
    DisposableListener<ArrayList<SysdynDataSet>> listener;

    protected abstract void selectionChanged(Collection<SysdynDataSet> var1);

    protected abstract void selectionChanged(ReadGraph var1, Resource var2);

    public void dispose() {
        if (this.listener != null) {
            this.listener.dispose();
        }
    }

    public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
        if (selection.isEmpty() || Boolean.TRUE.equals(PinTrend.getState())) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            Session session = Simantics.peekSession();
            if (session == null) {
                return;
            }
            if (this.listener != null) {
                this.listener.dispose();
            }
            this.listener = new DisposableListener<ArrayList<SysdynDataSet>>(){

                public void execute(ArrayList<SysdynDataSet> vars) {
                    if (vars != null) {
                        SysdynDatasetSelectionListener.this.selectionChanged(vars);
                    }
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }
            };
            try {
                session.syncRequest((Read)new Read<ArrayList<SysdynDataSet>>(){

                    public ArrayList<SysdynDataSet> perform(ReadGraph graph) throws DatabaseException {
                        Set vars = ISelectionUtils.filterSetSelection((Object)selection, Variable.class);
                        if (vars.isEmpty()) {
                            Set ress = ISelectionUtils.filterSetSelection((Object)selection, Resource.class);
                            List runtimes = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_VARIABLE_RESOURCE, Resource.class);
                            if (!runtimes.isEmpty()) {
                                Resource runtime = (Resource)runtimes.get(0);
                                for (Resource resource : ress) {
                                    Variable variable = SysdynDatasetSelectionListener.this.getVariable(graph, resource, runtime);
                                    if (variable == null) continue;
                                    vars.add(variable);
                                }
                                if (vars.isEmpty() && ress.size() == 1) {
                                    Resource r = (Resource)ress.iterator().next();
                                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                                    if (graph.isInstanceOf(r, jfree.ChartElement) && graph.hasStatement(r, jfree.ChartElement_component)) {
                                        r = graph.getSingleObject(r, jfree.ChartElement_component);
                                        SysdynDatasetSelectionListener.this.selectionChanged(graph, r);
                                        return null;
                                    }
                                }
                            } else if (ress.size() == 1) {
                                Resource r = (Resource)ress.iterator().next();
                                JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                                if (graph.isInstanceOf(r, jfree.Chart)) {
                                    SysdynDatasetSelectionListener.this.selectionChanged(graph, r);
                                    return null;
                                }
                            }
                        }
                        return SysdynDatasetSelectionListener.this.getDatasets(graph, vars);
                    }
                }, this.listener);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<SysdynDataSet> getDatasets(ReadGraph graph, Collection<Variable> variables) throws DatabaseException {
        ArrayList<SysdynDataSet> datasets = new ArrayList<SysdynDataSet>();
        for (Variable variable : variables) {
            Variable v = (Variable)graph.syncRequest((Read)new PossibleActiveVariableFromVariable(variable));
            if (v == null) continue;
            Variable dsVariable = v.browsePossible(graph, "#" + Functions.ACTIVE_DATASETS);
            Object object = null;
            if (dsVariable != null) {
                object = dsVariable.getValue(graph);
            }
            if (object == null || !(object instanceof ArrayList)) continue;
            for (Object o : (ArrayList)object) {
                if (!(o instanceof SysdynDataSet)) continue;
                datasets.add((SysdynDataSet)o);
            }
        }
        return datasets;
    }

    private Variable getVariable(ReadGraph g, Resource element, Resource runtime) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        if (runtime == null) {
            return null;
        }
        Resource resource = ModelingUtils.getPossibleElementCorrespondendence((ReadGraph)g, (Resource)element);
        if (resource != null && g.isInstanceOf(resource, sr.Shadow)) {
            resource = g.getPossibleObject(resource, sr.Shadow_original);
        }
        if (resource == null || !g.isInstanceOf(resource, sr.Variable)) {
            return null;
        }
        String variableURI = (String)g.getPossibleRelatedValue(runtime, dr.RuntimeDiagram_HasVariable);
        if (variableURI != null) {
            try {
                Variable compositeVariable = Variables.getVariable((ReadGraph)g, (String)variableURI);
                return compositeVariable.browsePossible(g, resource);
            }
            catch (MissingVariableException missingVariableException) {
                // empty catch block
            }
        }
        return null;
    }
}

