/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.values;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.ViewPart;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.ui.viewUtils.SysdynDatasetSelectionListener;

public class ValueView
extends ViewPart {
    private boolean disposed;
    private Composite baseComposite;
    private ISelectionListener selectionListener;
    private Table table;

    public void createPartControl(Composite parent) {
        this.disposed = false;
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(parent);
        this.baseComposite = new Composite(parent, 0x1040000);
        GridLayoutFactory.fillDefaults().applyTo(this.baseComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.baseComposite);
        this.table = new Table(this.baseComposite, 67586);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        this.table.setLayoutData((Object)data);
        this.selectionListener = new SysdynDatasetSelectionListener(){

            @Override
            protected void selectionChanged(final Collection<SysdynDataSet> activeDatasets) {
                if (ValueView.this.disposed) {
                    return;
                }
                ValueView.this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ValueView.this.updateTable(activeDatasets);
                    }
                });
            }

            @Override
            protected void selectionChanged(ReadGraph graph, Resource resource) {
            }
        };
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        if (selection != null) {
            this.selectionListener.selectionChanged(this.getSite().getPart(), selection);
        }
        KeyListener kl = new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 99) {
                    Clipboard cb = new Clipboard(e.display);
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    StringBuilder sb = new StringBuilder();
                    int columnCount = ValueView.this.table.getColumnCount();
                    int i = 0;
                    while (i < columnCount) {
                        TableColumn tc = ValueView.this.table.getColumn(i);
                        sb.append(tc.getText());
                        if (i < columnCount - 1) {
                            sb.append("\t");
                        } else {
                            sb.append("\n");
                        }
                        ++i;
                    }
                    TableItem[] tableItemArray = ValueView.this.table.getSelection();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem ti = tableItemArray[n2];
                        int i2 = 0;
                        while (i2 < columnCount) {
                            sb.append(ti.getText(i2));
                            if (i2 < columnCount - 1) {
                                sb.append("\t");
                            } else {
                                sb.append("\n");
                            }
                            ++i2;
                        }
                        ++n2;
                    }
                    cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
                }
            }
        };
        this.table.addKeyListener(kl);
    }

    private void updateTable(Collection<SysdynDataSet> activeDatasets) {
        if (activeDatasets.isEmpty() || !(activeDatasets instanceof ArrayList)) {
            return;
        }
        this.table.removeAll();
        if (this.table.getColumnCount() > 0) {
            int i = this.table.getColumnCount() - 1;
            while (i >= 0) {
                this.table.getColumn(i).dispose();
                --i;
            }
        }
        ArrayList datasets = (ArrayList)activeDatasets;
        ArrayList<String> titleList = new ArrayList<String>();
        titleList.add("Time");
        double[] times = new double[]{};
        int i = 0;
        while (i < datasets.size()) {
            String name = ((SysdynDataSet)datasets.get((int)i)).name;
            if (((SysdynDataSet)datasets.get((int)i)).resultIndex != null) {
                name = String.valueOf(name) + "(" + ((SysdynDataSet)datasets.get((int)i)).resultIndex + ")";
            }
            if (((SysdynDataSet)datasets.get((int)i)).result != null) {
                name = String.valueOf(name) + " : " + ((SysdynDataSet)datasets.get((int)i)).result;
            }
            titleList.add(name);
            if (times == null || ((SysdynDataSet)datasets.get((int)i)).values.length > times.length) {
                times = ((SysdynDataSet)datasets.get((int)i)).times;
            }
            ++i;
        }
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableItem[] items = ValueView.this.table.getItems();
                TableColumn column = (TableColumn)e.widget;
                TableColumn sortColumn = ValueView.this.table.getSortColumn();
                int dir = ValueView.this.table.getSortDirection();
                if (sortColumn == column) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    ValueView.this.table.setSortColumn(column);
                    dir = 128;
                }
                int index = 0;
                while (index < ValueView.this.table.getColumnCount()) {
                    if (ValueView.this.table.getColumn(index) == column) break;
                    ++index;
                }
                int i = 1;
                while (i < items.length) {
                    block13: {
                        Double value1;
                        String v1 = items[i].getText(index);
                        if (v1.contains("*")) {
                            v1 = v1.substring(0, v1.indexOf("*"));
                        }
                        try {
                            value1 = Double.parseDouble(v1);
                        }
                        catch (NumberFormatException ne) {
                            break block13;
                        }
                        int j = 0;
                        while (j < i) {
                            block14: {
                                Double value2;
                                String v2 = items[j].getText(index);
                                if (v2.contains("*")) {
                                    v2 = v2.substring(0, v2.indexOf("*"));
                                }
                                try {
                                    value2 = Double.parseDouble(v2);
                                }
                                catch (NumberFormatException ne) {
                                    break block14;
                                }
                                int result = value1.compareTo(value2);
                                if (dir == 128 && result < 0 || dir == 1024 && result > 0) {
                                    int columns = ValueView.this.table.getColumnCount();
                                    String[] values = new String[columns];
                                    int k = 0;
                                    while (k < columns) {
                                        values[k] = items[i].getText(k);
                                        ++k;
                                    }
                                    items[i].dispose();
                                    TableItem item = new TableItem(ValueView.this.table, 0, j);
                                    item.setText(values);
                                    items = ValueView.this.table.getItems();
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                ValueView.this.table.setSortColumn(column);
                ValueView.this.table.setSortDirection(dir);
            }
        };
        String[] titles = titleList.toArray(new String[titleList.size()]);
        int i2 = 0;
        while (i2 < titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(titles[i2]);
            column.addListener(13, sortListener);
            column.setMoveable(true);
            ++i2;
        }
        this.table.setSortColumn(this.table.getColumn(0));
        this.table.setSortDirection(128);
        i2 = 0;
        while (i2 < times.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, String.valueOf(times[i2]));
            int j = 0;
            while (j < datasets.size()) {
                String approximation = this.approximate(times[i2], i2, (SysdynDataSet)datasets.get(j));
                item.setText(j + 1, approximation);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            this.table.getColumn(i2).pack();
            ++i2;
        }
    }

    private String approximate(Double time, int index, SysdynDataSet dataset) {
        if (dataset.times.length == 0 || time > dataset.times[dataset.times.length - 1] || time < dataset.times[0]) {
            return "---";
        }
        if (index >= dataset.times.length) {
            index = dataset.times.length - 1;
        }
        int i = 0;
        while (i < dataset.times.length) {
            double t = dataset.times[i];
            if (t == time) {
                return String.valueOf(dataset.values[i]);
            }
            ++i;
        }
        int dir = this.table.getSortDirection();
        while (dataset.times[index] > time) {
            int n = index = dir == 128 ? index - 1 : index + 1;
        }
        while (dataset.times[index] <= time) {
            int n = index = dir == 128 ? index + 1 : index - 1;
        }
        int a = dir == 128 ? index - 1 : index;
        int b = dir == 128 ? index : index - 1;
        return String.valueOf(dataset.values[a] + (dataset.values[b] - dataset.values[a]) * (time - dataset.times[a]) / (dataset.times[b] - dataset.times[a])) + "*";
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        this.disposed = true;
    }
}

