/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;

public class IssueWithStringContext
extends StandardIssue {
    String[] stringContexts;

    public IssueWithStringContext(Resource type, Resource context, String ... stringContexts) {
        super(type, new Resource[]{context});
        this.stringContexts = stringContexts;
    }

    public String[] getStringContexts() {
        return this.stringContexts;
    }

    public void writeAdditionalContext(WriteGraph graph, Resource issue) throws DatabaseException {
        super.writeAdditionalContext(graph, issue);
        if (this.stringContexts != null && this.stringContexts.length > 0) {
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ArrayList<Resource> contexts = new ArrayList<Resource>();
            String[] stringArray = this.stringContexts;
            int n = this.stringContexts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Resource r = graph.newResource();
                graph.claim(r, L0.InstanceOf, L0.String);
                graph.claimValue(r, (Object)s, (Binding)Bindings.STRING);
                contexts.add(r);
                ++n2;
            }
            graph.claim(issue, SR.Validations_Issue_stringContexts, ListUtils.create((WriteGraph)graph, (Resource)L0.List, contexts));
        }
    }

    public static List<String> getStringContexts(ReadGraph graph, Variable property) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Variable issueVariable = property.getParent(graph);
        Resource issueResource = issueVariable.getRepresents(graph);
        Resource list = graph.getPossibleObject(issueResource, SR.Validations_Issue_stringContexts);
        if (list == null) {
            return Collections.emptyList();
        }
        List stringResources = ListUtils.toList((ReadGraph)graph, (Resource)list);
        ArrayList<String> result = new ArrayList<String>(stringResources.size());
        for (Resource r : stringResources) {
            result.add((String)graph.getValue(r, (Binding)Bindings.STRING));
        }
        return result;
    }
}

