/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.validation;

import java.util.Collections;
import java.util.List;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.issue.StandardIssue;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.sysdyn.SysdynResource;

public class EnumerationFunction {
    private static String NO_INDEXES = "Enumeration does not contain indexes.";

    @SCLValue(type="ReadGraph -> Resource -> [Issue]")
    public static List<Issue> enumerationIndexValidator(ReadGraph graph, Resource component) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (!graph.isInstanceOf(component, sr.Enumeration)) {
            return Collections.emptyList();
        }
        boolean noIndexes = false;
        try {
            Resource indexList = graph.getPossibleObject(component, sr.Enumeration_enumerationIndexList);
            List indexes = ListUtils.toList((ReadGraph)graph, (Resource)indexList);
            if (indexes.size() == 0) {
                noIndexes = true;
            }
        }
        catch (DatabaseException e) {
            noIndexes = true;
        }
        if (noIndexes) {
            return Collections.singletonList(new StandardIssue(sr.Validations_EmptyEnumerationIssue, new Resource[]{component}));
        }
        return Collections.emptyList();
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> String")
    public static String emptyEnumerationIssueDescription(ReadGraph graph, Resource converter, Variable property) throws DatabaseException {
        return NO_INDEXES;
    }
}

