/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.ui.utils.ArrayVariableUtils;
import org.simantics.sysdyn.ui.utils.NameValidator;
import org.simantics.sysdyn.utils.ModelUtils;

public class VariableNameValidator
extends NameValidator {
    @Override
    public void renameInEquations(WriteGraph graph, Resource variable, String originalName, String newName) throws DatabaseException {
        if (originalName.equals(newName)) {
            return;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Resource expressions = graph.getPossibleObject(variable, sr.Variable_expressionList);
        if (expressions != null) {
            List expressionList = ListUtils.toList((ReadGraph)graph, (Resource)expressions);
            for (Resource s : expressionList) {
                for (Resource p : graph.getPredicates(s)) {
                    String replaced;
                    String string;
                    Resource o = graph.getPossibleObject(s, p);
                    if (o == null || !graph.isInstanceOf(o, l0.String) || p.equals(sr.Expression_arrayRange) || (string = (String)graph.getRelatedValue(s, p)).equals(replaced = VariableNameValidator.replaceAllWords(string, originalName, newName))) continue;
                    graph.claimLiteral(s, p, (Object)replaced);
                }
            }
        }
    }

    @Override
    public void renameInAllEquations(WriteGraph graph, Resource configuration, String originalName, String newName) throws DatabaseException {
        if (originalName.equals(newName)) {
            return;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(configuration, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, sr.IndependentVariable)) continue;
            this.renameInEquations(graph, r, originalName, newName);
        }
    }

    private static String replaceAllWords(String original, String find, String replacement) {
        String pattern = "(.|\r|\n)*" + find.replace(" ", "\\s+") + "(.|\r|\n)*";
        if (!original.matches(pattern)) {
            return original;
        }
        if (find.equals(replacement)) {
            return original;
        }
        ExpressionParser parser = new ExpressionParser((Reader)new StringReader(original));
        try {
            parser.expr();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        HashMap allReferences = new HashMap();
        allReferences.putAll(parser.getReferences());
        allReferences.putAll(parser.getFunctionCallReferences());
        allReferences.putAll(parser.getEnumerationReferences());
        List replacedTokens = (List)allReferences.get(find);
        if (replacedTokens == null) {
            return original;
        }
        Collections.sort(replacedTokens);
        Collections.reverse(replacedTokens);
        String result = new String(original);
        for (Token token : replacedTokens) {
            int startingPoint = 0;
            int i = 0;
            while (i < token.beginLine - 1) {
                startingPoint = result.indexOf(10, startingPoint) + 1;
                ++i;
            }
            String begin = result.substring(0, startingPoint += token.beginColumn - 1);
            String end = result.substring(startingPoint);
            String regex = find.replaceAll(" ", "\\\\s+");
            end = end.replaceFirst(regex, replacement);
            result = String.valueOf(begin) + end;
        }
        return result;
    }

    @Override
    protected boolean nameIsTaken(ReadGraph graph, Resource variable, String name) throws DatabaseException {
        Resource library;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (variable == null) {
            return false;
        }
        SysdynModel sysdynModel = ModelUtils.getModel((ReadGraph)graph, (Resource)variable);
        if (sysdynModel == null) {
            return true;
        }
        sysdynModel.update(graph);
        Configuration configuration = sysdynModel.getConfiguration();
        if (configuration == null) {
            return true;
        }
        Model rootModel = null;
        ModuleType moduleType = configuration.getModuleType();
        if (moduleType != null) {
            Object o = moduleType.getParent();
            if (o instanceof Model) {
                rootModel = (Model)o;
            }
        } else {
            rootModel = configuration.getModel();
        }
        if ((library = graph.getPossibleObject(variable, l0.PartOf)) == null) {
            return true;
        }
        if ((library = graph.getPossibleObject(library, l0.PartOf)) == null) {
            return true;
        }
        if (graph.isInstanceOf(library, sr.SysdynModel)) {
            if (NameUtils.getSafeName((ReadGraph)graph, (Resource)library).equals(name)) {
                return true;
            }
            if (this.nameTakenByBuiltInFunction(graph, name)) {
                return true;
            }
            if (this.nameTakenBySharedFunctionLibrary(graph, library, null, name)) {
                return true;
            }
            if (this.nameTakenBySheet(sysdynModel, name)) {
                return true;
            }
        }
        if (this.nameTakenByTopLevelVariableOrModule(graph, sysdynModel, variable, name)) {
            return true;
        }
        if (rootModel != null && rootModel.containsModuleType(name)) {
            return true;
        }
        return this.nameTakenByFunctionFunctionLibraryOrModuleType(graph, library, name);
    }

    public boolean isValid(ReadGraph graph, Resource variable, String name, boolean hasRange) throws DatabaseException {
        if (hasRange) {
            String range = null;
            if (name.contains("[")) {
                StringTokenizer st = new StringTokenizer(name, "[]", true);
                if (st.countTokens() != 4) {
                    return false;
                }
                name = st.nextToken();
                if (!st.nextToken().equals("[")) {
                    return false;
                }
                range = st.nextToken();
                if (!st.nextToken().equals("]")) {
                    return false;
                }
            }
            if (range != null && !ArrayVariableUtils.isRangeValid(graph, variable, range)) {
                return false;
            }
        }
        return this.isValid(graph, variable, name);
    }

    public boolean isValid(final Resource variable, final String name, final boolean hasRange) {
        if (variable == null || name == null) {
            return false;
        }
        boolean result = false;
        try {
            result = (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    return VariableNameValidator.this.isValid(graph, variable, name, hasRange);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return result;
    }
}

