/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.ui.utils.NameValidator;

public class ModelNameValidator
extends NameValidator {
    @Override
    protected boolean nameIsTaken(ReadGraph graph, Resource model, String name) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (model == null) {
            return false;
        }
        if (this.nameTakenByFunctionFunctionLibraryOrModuleType(graph, model, name)) {
            return true;
        }
        Resource configurationResource = graph.getPossibleObject(model, SIMU.HasConfiguration);
        if (configurationResource == null) {
            return true;
        }
        SysdynModel sysdynModel = SysdynModelManager.getInstance((Session)graph.getSession()).getModel(graph, configurationResource);
        sysdynModel.update(graph);
        if (this.nameTakenByTopLevelVariableOrModule(graph, sysdynModel, null, name)) {
            return true;
        }
        if (this.nameTakenByBuiltInFunction(graph, name)) {
            return true;
        }
        if (this.nameTakenBySharedFunctionLibrary(graph, model, null, name)) {
            return true;
        }
        return this.nameTakenBySheet(sysdynModel, name);
    }

    @Override
    public void renameInEquations(WriteGraph graph, Resource variable, String originalName, String newName) throws DatabaseException {
    }

    @Override
    public void renameInAllEquations(WriteGraph graph, Resource configuration, String originalName, String newName) throws DatabaseException {
    }
}

