/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.awt.Color;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.diagram.G2DUtils;
import org.simantics.jfreechart.chart.IRenderer;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.Functions;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.adapter.VariableRVIUtils;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.ui.trend.XYDataset;
import org.simantics.sysdyn.ui.trend.XYDatasetTempSeries;
import org.simantics.utils.datastructures.Pair;

public class XYDatasetRequest
implements Read<Pair<ArrayList<XYDatasetTempSeries>, IRenderer>> {
    protected Resource dataset;

    public XYDatasetRequest(Resource dataset) {
        this.dataset = dataset;
    }

    public Pair<ArrayList<XYDatasetTempSeries>, IRenderer> perform(ReadGraph graph) throws DatabaseException {
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        IRenderer renderer = null;
        Resource rendererResource = graph.getPossibleObject(this.dataset, jfree.Dataset_renderer);
        if (rendererResource != null) {
            renderer = (IRenderer)graph.adapt(rendererResource, IRenderer.class);
        }
        ArrayList<XYDatasetTempSeries> series = new ArrayList<XYDatasetTempSeries>();
        String realizationURI = XYDataset.getRealizationURI(graph, this.dataset);
        if (realizationURI == null) {
            return new Pair(series, (Object)renderer);
        }
        double[] domainValues = null;
        Resource seriesList = graph.getPossibleObject(this.dataset, jfree.Dataset_seriesList);
        if (seriesList != null) {
            for (Resource r : ListUtils.toList((ReadGraph)graph, (Resource)seriesList)) {
                String rvi = (String)graph.getPossibleRelatedValue(r, jfree.variableRVI);
                if (rvi == null) continue;
                try {
                    ArrayList result2;
                    Resource c;
                    Integer width = (Integer)graph.getPossibleRelatedValue(r, jfree.Series_lineWidth, (Binding)Bindings.INTEGER);
                    if (width == null) {
                        width = 1;
                    }
                    Color color = (c = graph.getPossibleObject(r, jfree.color)) == null ? null : G2DUtils.getColor((ReadGraph)graph, (Resource)c);
                    String label = (String)graph.getPossibleRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasLabel);
                    Variable v = Variables.getVariable((ReadGraph)graph, (String)(String.valueOf(realizationURI) + rvi));
                    if (v == null) {
                        return new Pair(series, (Object)renderer);
                    }
                    Variable dsVariable = v.browsePossible(graph, "#" + Functions.ACTIVE_DATASETS);
                    Object object = null;
                    if (dsVariable != null) {
                        object = dsVariable.getValue(graph);
                    }
                    if (object == null || !(object instanceof ArrayList)) {
                        return new Pair(series, (Object)renderer);
                    }
                    ArrayList datasets = new ArrayList();
                    for (Object o : (ArrayList)object) {
                        if (!(o instanceof SysdynDataSet)) continue;
                        datasets.add((SysdynDataSet)o);
                    }
                    String[] filter = (String[])graph.getPossibleRelatedValue(r, jfree.variableFilter);
                    if (filter != null && (result2 = VariableRVIUtils.getDataset(datasets, (String[])filter)) != null) {
                        datasets = result2;
                    }
                    for (SysdynDataSet dataset : datasets) {
                        double[] ta;
                        double[] va = dataset.values;
                        if (domainValues != null) {
                            int i;
                            double value;
                            ta = domainValues;
                            if (domainValues.length > va.length) {
                                value = va[0];
                                va = new double[domainValues.length];
                                i = 0;
                                while (i < domainValues.length) {
                                    va[i] = value;
                                    ++i;
                                }
                            }
                            if (domainValues.length < va.length && domainValues.length == 2 && domainValues[0] == domainValues[1]) {
                                value = domainValues[0];
                                ta = new double[va.length];
                                i = 0;
                                while (i < va.length) {
                                    ta[i] = value;
                                    ++i;
                                }
                            }
                        } else {
                            ta = dataset.times;
                        }
                        if (ta == null || va == null || va.length != ta.length) continue;
                        String name = dataset.name;
                        if (label != null) {
                            name = label;
                        }
                        if (dataset.resultIndex != null) {
                            name = String.valueOf(name) + "(" + dataset.resultIndex + ")";
                        }
                        if (dataset.result != null && !dataset.result.isEmpty()) {
                            name = String.valueOf(name) + " : " + dataset.result;
                        }
                        if (ta.length == 0 || va.length == 0) continue;
                        XYDatasetTempSeries tempSeries = new XYDatasetTempSeries(name, new double[][]{ta, va}, width, color);
                        this.getAdditionalSeriesProperties(graph, r, tempSeries);
                        series.add(tempSeries);
                    }
                }
                catch (MissingVariableException missingVariableException) {
                    // empty catch block
                }
            }
        }
        return new Pair(series, (Object)renderer);
    }

    protected void getAdditionalSeriesProperties(ReadGraph graph, Resource r, XYDatasetTempSeries tempSeries) throws DatabaseException {
    }
}

