/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.ChartVariable;
import org.simantics.jfreechart.chart.properties.IAllVariablesOfModel;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.strings.AlphanumComparator;

public class AllVariablesOfModel
implements IAllVariablesOfModel {
    private final Resource model;

    public AllVariablesOfModel(Resource model) {
        this.model = model;
    }

    public Read<Collection<ChartVariable>> getVariablesQuery() {
        return new VariableQuery();
    }

    public String getVariablesLabel(ReadGraph graph, String variableId) throws DatabaseException {
        return variableId.substring(1).replace('/', '.');
    }

    private void ReadConfiguration(ReadGraph graph, Resource configuration, String path, Collection<ChartVariable> items) throws DatabaseException {
        String name;
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
        for (Resource resource : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.IndependentVariable))) {
            name = String.valueOf(path) + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
            items.add(new ChartVariable(name, name));
        }
        for (Resource resource : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Input))) {
            name = String.valueOf(path) + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource);
            items.add(new ChartVariable(name, name));
        }
        for (Resource module : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, sr.Module))) {
            Resource instanceOf = graph.getPossibleObject(module, l0.InstanceOf);
            Resource conf = graph.getPossibleObject(instanceOf, sr2.IsDefinedBy);
            if (conf == null) continue;
            String p = String.valueOf(path) + NameUtils.getSafeName((ReadGraph)graph, (Resource)module) + ".";
            this.ReadConfiguration(graph, conf, p, items);
        }
    }

    private class VariableQuery
    implements Read<Collection<ChartVariable>> {
        private VariableQuery() {
        }

        public Collection<ChartVariable> perform(ReadGraph graph) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SimulationResource simu = SimulationResource.getInstance((ReadGraph)graph);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ArrayList<ChartVariable> result = new ArrayList<ChartVariable>();
            Resource model = AllVariablesOfModel.this.model;
            while (model != null && !graph.isInstanceOf(model, sr.SysdynModel)) {
                model = graph.getPossibleObject(model, l0.PartOf);
            }
            if (model == null) {
                return result;
            }
            Resource conf = graph.getSingleObject(model, simu.HasConfiguration);
            AllVariablesOfModel.this.ReadConfiguration(graph, conf, "", result);
            result.add(new ChartVariable("time", "time"));
            Collections.sort(result, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
            return result;
        }
    }
}

