/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.db.Resource;
import org.simantics.db.procedure.Listener;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.ui.GraphvizComponent;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class StructureTabItem
extends CTabItem {
    protected GraphvizComponent component;
    protected GraphListener graphListener;
    protected Composite structureComposite;
    protected Resource currentSelection;

    public StructureTabItem(CTabFolder parent, int style) {
        super(parent, style);
        this.structureComposite = new Composite((Composite)parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.structureComposite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.structureComposite);
        this.component = new GraphvizComponent(this.structureComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.component);
    }

    public void drawSelection(ISelection selection) {
        Object[] els;
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (els = ((IStructuredSelection)selection).toArray()).length == 1) {
            Set ress = ISelectionUtils.filterSetSelection((Object)selection, Resource.class);
            if (ress.isEmpty()) {
                return;
            }
            Resource r = ress.toArray(Resource.NONE)[0];
            if (r != null && !r.equals(this.currentSelection)) {
                this.currentSelection = r;
                this.readGraph(this.currentSelection);
            }
        }
    }

    protected abstract void readGraph(Resource var1);

    protected String getJobLabel() {
        return "Loading dependencies graph";
    }

    class GraphListener
    implements Listener<Graph> {
        private boolean disposed = false;

        GraphListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void exception(Throwable e) {
            e.printStackTrace();
        }

        public void execute(final Graph graph) {
            Job job = new Job(StructureTabItem.this.getJobLabel()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!GraphListener.this.isDisposed()) {
                        ((GraphListener)GraphListener.this).StructureTabItem.this.component.setGraph(graph, "dot");
                        ((GraphListener)GraphListener.this).StructureTabItem.this.component.fit();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

