/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.Node;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;

public class DependencyGraphRequest
implements Read<Graph> {
    protected Resource root;
    protected HashMap<Resource, Node> nodes;
    protected boolean isInverted;
    protected int levels;

    public DependencyGraphRequest(Resource root, int levels, boolean isInverted) {
        this.root = root;
        this.isInverted = isInverted;
        this.levels = levels;
    }

    public Graph perform(ReadGraph g) throws DatabaseException {
        this.nodes = new HashMap();
        Graph graph = new Graph();
        graph.setRankdir("LR");
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        Resource element = g.getPossibleObject(this.root, mr.ElementToComponent);
        if (element != null) {
            this.root = element;
        }
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(this.root, sr.IndependentVariable) || g.isInstanceOf(this.root, sr.Input)) {
            this.setRoot(g, (IGraph)graph, this.root);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.add(this.root);
            int i = 0;
            while (i < this.levels && !resources.isEmpty()) {
                ArrayList<Resource> newResources = new ArrayList<Resource>();
                for (Resource r : resources) {
                    newResources.addAll(this.setDependencies(g, (IGraph)graph, r));
                }
                resources = new ArrayList(newResources);
                ++i;
            }
        }
        return graph;
    }

    protected void setRoot(ReadGraph g, IGraph graph, Resource root) throws DatabaseException {
        Node n = new Node(graph, this.getName(g, root));
        this.setShape(g, root, n);
        n.set("style", "filled");
        n.setFillColor("#d3d3d3");
        this.nodes.put(root, n);
    }

    private Collection<Resource> getDependants(ReadGraph g, IGraph graph, Resource r, Resource toDependency, Resource fromDependency, Resource connectionType) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        Collection dependencies = (Collection)g.syncRequest((Read)new ObjectsWithType(r, toDependency, connectionType));
        ArrayList<Resource> dependants = new ArrayList<Resource>();
        for (Resource d : dependencies) {
            Resource dependant = g.getPossibleObject(d, fromDependency);
            if (dependant == null) continue;
            if (g.isInstanceOf(dependant, sr.Cloud)) break;
            if (!this.nodes.containsKey(dependant)) {
                Node n = new Node(graph, this.getName(g, dependant));
                this.setShape(g, dependant, n);
                this.nodes.put(dependant, n);
                dependants.add(dependant);
            }
            if (this.isInverted) {
                new Edge(graph, (Identifiable)this.nodes.get(r), (Identifiable)this.nodes.get(dependant));
                continue;
            }
            new Edge(graph, (Identifiable)this.nodes.get(dependant), (Identifiable)this.nodes.get(r));
        }
        return dependants;
    }

    private Collection<Resource> setDependencies(ReadGraph g, IGraph graph, Resource r) throws DatabaseException {
        Collection<Resource> dependants;
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(r, sr.Module)) {
            return Collections.emptyList();
        }
        if (this.isInverted) {
            dependants = this.getDependants(g, graph, r, sr.Variable_isTailOf, sr.Variable_HasHead, sr.Dependency);
            if (g.isInstanceOf(r, sr.Valve)) {
                dependants.addAll(this.getDependants(g, graph, r, sr.Variable_isTailOf, sr.Variable_HasHead, sr.Flow));
                dependants.addAll(this.getDependants(g, graph, r, sr.Variable_isHeadOf, sr.Variable_HasTail, sr.Flow));
            }
        } else {
            dependants = this.getDependants(g, graph, r, sr.Variable_isHeadOf, sr.Variable_HasTail, sr.Dependency);
            if (g.isInstanceOf(r, sr.Stock)) {
                dependants.addAll(this.getDependants(g, graph, r, sr.Variable_isTailOf, sr.Variable_HasHead, sr.Flow));
                dependants.addAll(this.getDependants(g, graph, r, sr.Variable_isHeadOf, sr.Variable_HasTail, sr.Flow));
            }
        }
        return dependants;
    }

    protected void setShape(ReadGraph g, Resource r, Node n) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(r, sr.Stock)) {
            n.setShape("rectangle");
        } else if (g.isInstanceOf(r, sr.Module)) {
            n.setShape("rectangle");
            n.setStyle("rounded");
        } else {
            n.setShape("ellipse");
        }
    }

    protected String getName(ReadGraph g, Resource r) throws DatabaseException {
        return (String)g.getRelatedValue(r, Layer0.getInstance((ReadGraph)g).HasName);
    }
}

