/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;

public class ReferenceRow {
    Resource variable;
    Resource module;
    Resource dependency;
    String name;

    public ReferenceRow(Resource module, Resource dependency, Resource variable) {
        this.module = module;
        this.variable = variable;
        this.dependency = dependency;
    }

    public Resource getModule() {
        return this.module;
    }

    public Resource getVariable() {
        return this.variable;
    }

    public Resource getDependency() {
        return this.dependency;
    }

    public String getName() {
        String name = null;
        try {
            name = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    return (String)graph.getRelatedValue(ReferenceRow.this.getVariable(), Layer0.getInstance((ReadGraph)graph).HasName);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return name;
    }

    public String getValue() {
        if (this.dependency == null) {
            return "";
        }
        String value = null;
        try {
            value = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Resource valueResource = graph.getPossibleObject(ReferenceRow.this.dependency, sr.Variable_HasTail);
                    if (!graph.isInstanceOf(valueResource, sr.Variable)) {
                        valueResource = graph.getPossibleObject(ReferenceRow.this.dependency, sr.Variable_HasHead);
                    }
                    if (graph.isInstanceOf(valueResource, sr.Shadow)) {
                        valueResource = graph.getPossibleObject(valueResource, sr.Shadow_original);
                    }
                    if (valueResource == null || !graph.isInstanceOf(valueResource, sr.Variable)) {
                        return "";
                    }
                    return (String)graph.getRelatedValue(valueResource, l0.HasName, (Binding)Bindings.STRING);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return value;
    }

    public void setRefersTo(final Resource dependency) {
        if (dependency != null && dependency.equals(this.dependency)) {
            return;
        }
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                if (ReferenceRow.this.getDependency() != null && graph.hasStatement(ReferenceRow.this.getDependency(), sr.Dependency_refersTo)) {
                    graph.deny(ReferenceRow.this.getDependency(), sr.Dependency_refersTo);
                }
                if (dependency != null && graph.hasStatement(dependency, sr.Dependency_refersTo)) {
                    graph.deny(dependency, sr.Dependency_refersTo);
                }
                ReferenceRow.this.setDependency(null);
                if (dependency != null) {
                    ReferenceRow.this.setDependency(dependency);
                    graph.claim(ReferenceRow.this.getDependency(), SysdynResource.getInstance((ReadGraph)graph).Dependency_refersTo, ReferenceRow.this.getVariable());
                }
            }
        });
    }

    private void setDependency(Resource dependency) {
        this.dependency = dependency;
    }
}

