/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.functions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.Timer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IsParent;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelParser.ModelParser;
import org.simantics.sysdyn.modelParser.ParseException;
import org.simantics.sysdyn.modelParser.Token;
import org.simantics.sysdyn.modelParser.TokenMgrError;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.utils.SyntaxError;
import org.simantics.utils.ui.AdaptionUtils;

public class FunctionCodeWidget
implements Widget {
    private ExpressionField modelicaCode;
    private Resource function;
    private Timer updateChartTimer;
    private static int VALIDATION_DELAY_TIME = 500;
    private ArrayList<ModelParser.Parameter> inputs;
    private ArrayList<ModelParser.Parameter> outputs;

    public FunctionCodeWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.modelicaCode = new ExpressionField(parent, 2048, null, false, null);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.modelicaCode);
        this.modelicaCode.getSourceViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if ((event.keyCode == 13 || event.keyCode == 0x1000050) && (event.stateMask & 0x20000) == 0) {
                    Listener l;
                    Listener[] listeners;
                    event.doit = false;
                    Listener[] listenerArray = listeners = FunctionCodeWidget.this.modelicaCode.getSourceViewer().getTextWidget().getListeners(16);
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        l = listenerArray[n2];
                        FunctionCodeWidget.this.modelicaCode.getSourceViewer().getTextWidget().removeListener(16, l);
                        ++n2;
                    }
                    ((StyledText)event.widget).getParent().forceFocus();
                    FunctionCodeWidget.this.save();
                    listenerArray = listeners;
                    n = listeners.length;
                    n2 = 0;
                    while (n2 < n) {
                        l = listenerArray[n2];
                        FunctionCodeWidget.this.modelicaCode.getSourceViewer().getTextWidget().addListener(16, l);
                        ++n2;
                    }
                }
            }
        });
        this.modelicaCode.getSourceViewer().getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FunctionCodeWidget.this.validateFieldsTimed();
            }
        });
        this.modelicaCode.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                FunctionCodeWidget.this.save();
            }
        });
        this.updateChartTimer = new Timer(VALIDATION_DELAY_TIME, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FunctionCodeWidget.this.modelicaCode == null || FunctionCodeWidget.this.modelicaCode.isDisposed()) {
                    return;
                }
                FunctionCodeWidget.this.modelicaCode.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FunctionCodeWidget.this.validate();
                    }
                });
            }
        });
        this.updateChartTimer.setRepeats(false);
    }

    public void setInput(ISessionContext context, Object input) {
        this.function = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        try {
            String code = (String)context.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    String code = (String)graph.getPossibleRelatedValue(FunctionCodeWidget.this.function, SysdynResource.getInstance((ReadGraph)graph).SysdynModelicaFunction_modelicaFunctionCode);
                    if (code == null && (code = (String)graph.getPossibleRelatedValue(FunctionCodeWidget.this.function, SysdynResource.getInstance((ReadGraph)graph).SysdynModelicaFunction_modelicaFunctionInterface)) == null) {
                        code = new String("");
                    }
                    return code;
                }
            });
            if (code != null) {
                this.modelicaCode.setExpression(code);
                boolean editable = (Boolean)context.getSession().syncRequest((Read)new Read<Boolean>(){

                    public Boolean perform(ReadGraph graph) throws DatabaseException {
                        boolean asd = new IsParent(SysdynResource.getInstance((ReadGraph)graph).Built$in_Functions, FunctionCodeWidget.this.function).perform(graph);
                        return !asd;
                    }
                });
                this.modelicaCode.getSourceViewer().setEditable(editable);
                this.validate();
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void validateFieldsTimed() {
        this.validateFieldsTimed(VALIDATION_DELAY_TIME);
    }

    public void validateFieldsTimed(int delay) {
        this.updateChartTimer.setDelay(delay);
        if (!this.updateChartTimer.isRunning()) {
            this.updateChartTimer.start();
        } else {
            this.updateChartTimer.restart();
        }
    }

    public void validate() {
        this.modelicaCode.resetAnnotations();
        String code = this.modelicaCode.getExpression();
        StringReader sr = new StringReader(code);
        ModelParser modelParser = new ModelParser((Reader)sr);
        try {
            modelParser.parse_composition();
            this.inputs = modelParser.getInputs();
            this.outputs = modelParser.getOutputs();
        }
        catch (ParseException e1) {
            Token token = e1.currentToken;
            this.modelicaCode.setSyntaxError(new SyntaxError(token.image, "Syntax error", token.beginLine, token.beginColumn, token.endLine, token.endColumn));
        }
        catch (TokenMgrError err) {
            String message = err.getMessage();
            String line = message.substring(0, message.indexOf(","));
            line = line.substring(line.lastIndexOf(" ") + 1);
            String column = message.substring(message.indexOf(",") + 1, message.indexOf("."));
            column = column.substring(column.lastIndexOf(" ") + 1);
            try {
                Integer endLine = Integer.parseInt(line);
                Integer endColumn = Integer.parseInt(column);
                Token token = modelParser.token;
                this.modelicaCode.setSyntaxError(new SyntaxError(token.image, "Syntax error", token.endLine, token.endColumn, endLine, endColumn));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void save() {
        if (!this.modelicaCode.getSourceViewer().isEditable()) {
            return;
        }
        final String code = this.modelicaCode.getExpression();
        this.validate();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                this.removeInputList(graph);
                this.createInputList(graph);
                this.removeOutputList(graph);
                this.createOutputList(graph);
                graph.claimLiteral(FunctionCodeWidget.this.function, sr.SysdynModelicaFunction_modelicaFunctionCode, (Object)code);
            }

            private void removeInputList(WriteGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource oldInputList = graph.getPossibleObject(FunctionCodeWidget.this.function, sr.SysdynModelicaFunction_inputs);
                if (oldInputList != null) {
                    for (Resource input : ListUtils.toList((ReadGraph)graph, (Resource)oldInputList)) {
                        Resource variableLengthInputLabels;
                        if (graph.isInstanceOf(input, sr.SysdynModelicaFunction_VariableLengthInput) && (variableLengthInputLabels = graph.getPossibleObject(input, sr.SysdynModelicaFunction_VariableLengthInput_shownLabels)) != null) {
                            for (Resource label : ListUtils.toList((ReadGraph)graph, (Resource)variableLengthInputLabels)) {
                                RemoverUtil.remove((WriteGraph)graph, (Resource)label);
                            }
                            RemoverUtil.remove((WriteGraph)graph, (Resource)variableLengthInputLabels);
                        }
                        RemoverUtil.remove((WriteGraph)graph, (Resource)input);
                    }
                    RemoverUtil.remove((WriteGraph)graph, (Resource)oldInputList);
                }
            }

            private void createInputList(WriteGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                ArrayList<Resource> inputResources = new ArrayList<Resource>();
                if (FunctionCodeWidget.this.inputs != null) {
                    for (ModelParser.Parameter input : FunctionCodeWidget.this.inputs) {
                        Resource r = GraphUtils.create2((WriteGraph)graph, (Resource)sr.SysdynModelicaFunction_Input, (Object[])new Object[]{l0.HasName, input.name, sr.Variable_type, input.type, sr.SysdynModelicaFunction_optional, input.optional ? l0.True : l0.False});
                        if (input.description != null) {
                            graph.claimLiteral(r, sr.SysdynModelicaFunction_definition, (Object)input.description);
                        }
                        inputResources.add(r);
                    }
                    graph.claim(FunctionCodeWidget.this.function, sr.SysdynModelicaFunction_inputs, ListUtils.create((WriteGraph)graph, inputResources));
                }
            }

            private void removeOutputList(WriteGraph graph) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource oldOutputList = graph.getPossibleObject(FunctionCodeWidget.this.function, sr.SysdynModelicaFunction_outputs);
                if (oldOutputList != null) {
                    for (Resource output : ListUtils.toList((ReadGraph)graph, (Resource)oldOutputList)) {
                        RemoverUtil.remove((WriteGraph)graph, (Resource)output);
                    }
                    RemoverUtil.remove((WriteGraph)graph, (Resource)oldOutputList);
                }
            }

            private void createOutputList(WriteGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                ArrayList<Resource> outputResources = new ArrayList<Resource>();
                if (FunctionCodeWidget.this.outputs != null) {
                    for (ModelParser.Parameter output : FunctionCodeWidget.this.outputs) {
                        Resource r = GraphUtils.create2((WriteGraph)graph, (Resource)sr.SysdynModelicaFunction_Output, (Object[])new Object[]{l0.HasName, output.name, sr.Variable_type, output.type});
                        if (output.description != null) {
                            graph.claimLiteral(r, sr.SysdynModelicaFunction_definition, (Object)output.description);
                        }
                        outputResources.add(r);
                    }
                    graph.claim(FunctionCodeWidget.this.function, sr.SysdynModelicaFunction_outputs, ListUtils.create((WriteGraph)graph, outputResources));
                }
            }
        });
    }
}

