/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class LookupChartPanel
extends ChartPanel {
    private XYItemEntity dragPrevEntity;
    private boolean drawing;
    private XYSeries series;
    private JFreeChart chart;
    private SeriesChangeListener changeListener;

    public LookupChartPanel(JFreeChart chart) {
        super(chart);
        this.chart = chart;
        XYSeriesCollection collection = (XYSeriesCollection)((XYPlot)chart.getPlot()).getDataset();
        this.series = collection.getSeries(0);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragPrevEntity != null) {
            Number nextX;
            int item = this.dragPrevEntity.getItem();
            XYPlot plot = (XYPlot)this.chart.getPlot();
            ValueAxis rangeAxis = plot.getRangeAxis();
            ValueAxis domainAxis = plot.getDomainAxis();
            Point2D location = this.getLocationOnChart(this.getMouseLocation(e));
            Number prevX = item == 0 ? (Number)null : (Number)this.series.getX(item - 1);
            Number number = nextX = item == this.series.getItemCount() - 1 ? (Number)null : (Number)this.series.getX(item + 1);
            if (this.series.indexOf((Number)location.getX()) >= 0 && this.series.indexOf((Number)location.getX()) != item) {
                return;
            }
            if (prevX != null && location.getX() < prevX.doubleValue()) {
                location.setLocation(this.series.getX(item).doubleValue(), location.getY());
            } else if (nextX != null && location.getX() > nextX.doubleValue()) {
                location.setLocation(this.series.getX(item).doubleValue(), location.getY());
            } else if (location.getX() > domainAxis.getUpperBound()) {
                location.setLocation(domainAxis.getUpperBound(), location.getY());
            } else if (location.getX() < domainAxis.getLowerBound()) {
                location.setLocation(domainAxis.getLowerBound(), location.getY());
            }
            if (location.getY() > rangeAxis.getUpperBound()) {
                location.setLocation(location.getX(), rangeAxis.getUpperBound());
            } else if (location.getY() < rangeAxis.getLowerBound()) {
                location.setLocation(location.getX(), rangeAxis.getLowerBound());
            }
            this.removeItemFromSeries(this.dragPrevEntity.getItem());
            this.addLocationToSeries(location);
        } else {
            ChartEntity currEntity = this.getEntityForPoint(e.getX(), e.getY());
            if (!this.drawing && currEntity instanceof XYItemEntity) {
                this.dragPrevEntity = (XYItemEntity)currEntity;
            } else if (currEntity instanceof PlotEntity) {
                this.drawing = true;
                Point2D locationOnChart = this.getLocationOnChart(this.getMouseLocation(e));
                int item = this.series.indexOf((Number)locationOnChart.getX());
                if (item >= 0) {
                    Point2D.Double location = new Point2D.Double(this.series.getX(item).doubleValue(), this.series.getY(item).doubleValue());
                    Point2D javaLocation = this.getLocationOnJava2D(location);
                    this.removeItemFromSeries(item);
                    this.addLocationToSeries(this.getLocationOnChart(new Point2D.Double(javaLocation.getX(), e.getY())));
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isDragging()) {
            this.dragPrevEntity = null;
            if (this.changeListener != null) {
                this.changeListener.seriesChanged(null);
            }
        }
        this.drawing = false;
    }

    public void mouseClicked(MouseEvent e) {
        ChartEntity entity;
        if (e.getButton() == 1) {
            this.addLocationToSeries(this.getLocationOnChart(this.getMouseLocation(e)));
        } else if (e.getButton() == 3 && (entity = this.getEntityForPoint(e.getX(), e.getY())) instanceof XYItemEntity) {
            XYItemEntity xyentity = (XYItemEntity)entity;
            this.removeItemFromSeries(xyentity.getItem());
        }
    }

    private Point2D getLocationOnChart(Point2D coordinates) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        ChartRenderingInfo info = this.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        double chartX = plot.getDomainAxis().java2DToValue(coordinates.getX(), dataArea, plot.getDomainAxisEdge());
        double chartY = plot.getRangeAxis().java2DToValue(coordinates.getY(), dataArea, plot.getRangeAxisEdge());
        return new Point2D.Double(chartX, chartY);
    }

    private Point2D getLocationOnJava2D(Point2D location) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        ChartRenderingInfo info = this.getChartRenderingInfo();
        Rectangle2D dataArea = info.getPlotInfo().getDataArea();
        double javaX = plot.getDomainAxis().valueToJava2D(location.getX(), dataArea, plot.getDomainAxisEdge());
        double javaY = plot.getRangeAxis().valueToJava2D(location.getY(), dataArea, plot.getRangeAxisEdge());
        return new Point2D.Double(javaX, javaY);
    }

    public void addLocationToSeries(Point2D location) {
        if (this.series.indexOf((Number)location.getX()) < 0) {
            this.series.add(location.getX(), location.getY());
        }
    }

    public void removeItemFromSeries(int item) {
        this.series.remove(item);
    }

    public void resetChart(XYDataset dataset) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setDataset(dataset);
        XYSeriesCollection collection = (XYSeriesCollection)plot.getDataset();
        this.series = collection.getSeries(0);
    }

    private Point2D getMouseLocation(MouseEvent e) {
        int mouseX = e.getX();
        int mouseY = e.getY();
        Point2D p = this.translateScreenToJava2D(new Point(mouseX, mouseY));
        return p;
    }

    public void addSeriesChangeListener(SeriesChangeListener listener) {
        this.changeListener = listener;
        this.series.addChangeListener(this.changeListener);
    }

    public boolean isDragging() {
        return this.dragPrevEntity != null;
    }
}

