/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionFieldConfiguration;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.utils.SyntaxError;

public class ExpressionField
extends Composite {
    protected SourceViewer _sourceViewer;
    protected IDocument _document;
    protected AnnotationModel _annotationModel;
    public static final String MISSING_LINK = "MissingLink";
    public static final String NO_SUCH_VARIABLE = "NoSuchVariable";
    public static final String SYNTAX_ERROR = "SyntaxError";
    public static final String SYNTAX_WARNING = "SyntaxWarning";
    String oldExpression;
    IAnnotationAccess annotationAccess = new DefaultMarkerAnnotationAccess();
    ExpressionFieldConfiguration expressionFieldConfiguration;
    private final LocalResourceManager resourceManager;
    private final RGB warningRGB = new RGB(255, 215, 0);
    private final RGB errorRGB = new RGB(255, 0, 0);

    public ExpressionField(Composite parent, int style, Table allowedVariables, boolean allowFunctions, ExpressionWidgetInput input) {
        this(parent, style, allowedVariables, allowFunctions, false, input);
    }

    public ExpressionField(Composite parent, int style, Table allowedVariables, boolean allowFunctions, boolean allowEmpty, ExpressionWidgetInput input) {
        super(parent, style);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        int styles = 66114;
        this._document = new Document();
        this._document.set("");
        this._annotationModel = new AnnotationModel();
        this._annotationModel.connect(this._document);
        this._sourceViewer = new SourceViewer((Composite)this, null, null, true, styles);
        this.expressionFieldConfiguration = new ExpressionFieldConfiguration((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), this._sourceViewer.getControl()), allowedVariables, allowFunctions, allowEmpty, input);
        this._sourceViewer.configure((SourceViewerConfiguration)this.expressionFieldConfiguration);
        AnnotationPainter painter = new AnnotationPainter((ISourceViewer)this._sourceViewer, this.annotationAccess);
        this._sourceViewer.addPainter((IPainter)painter);
        Color warningColor = this.resourceManager.createColor(this.warningRGB);
        Color errorColor = this.resourceManager.createColor(this.errorRGB);
        painter.addAnnotationType((Object)MISSING_LINK);
        painter.setAnnotationTypeColor((Object)MISSING_LINK, warningColor);
        painter.addAnnotationType((Object)NO_SUCH_VARIABLE);
        painter.setAnnotationTypeColor((Object)NO_SUCH_VARIABLE, errorColor);
        painter.addAnnotationType((Object)SYNTAX_ERROR);
        painter.setAnnotationTypeColor((Object)SYNTAX_ERROR, errorColor);
        painter.addAnnotationType((Object)SYNTAX_WARNING);
        painter.setAnnotationTypeColor((Object)SYNTAX_WARNING, warningColor);
        this._sourceViewer.setDocument(this._document, (IAnnotationModel)this._annotationModel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this._sourceViewer.getControl());
        PaintManager paintManager = new PaintManager((ITextViewer)this._sourceViewer);
        MatchingCharacterPainter matchingCharacterPainter = new MatchingCharacterPainter((ISourceViewer)this._sourceViewer, (ICharacterPairMatcher)new DefaultCharacterPairMatcher(new char[]{'(', ')', '{', '}', '[', ']'}));
        matchingCharacterPainter.setColor(this.resourceManager.createColor(new RGB(160, 160, 160)));
        paintManager.addPainter((IPainter)matchingCharacterPainter);
        this._sourceViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (!ExpressionField.this.isAssistSessionActive() && e.keyCode == 27 && ExpressionField.this.getExpression() != null) {
                    ((StyledText)e.widget).setText(ExpressionField.this.oldExpression);
                    ((StyledText)e.widget).setSelection(ExpressionField.this.getExpression().length());
                }
            }
        });
        this._sourceViewer.getTextWidget().addFocusListener(new FocusListener(){
            Point selection = null;

            public void focusLost(FocusEvent e) {
                this.selection = ((StyledText)e.widget).getSelection();
                ((StyledText)e.widget).setSelection(0);
            }

            public void focusGained(FocusEvent e) {
                if (this.selection != null) {
                    ((StyledText)e.widget).setSelection(this.selection);
                }
            }
        });
        this._sourceViewer.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.character == ' ') {
                    if (ExpressionField.this._sourceViewer.canDoOperation(13)) {
                        ExpressionField.this._sourceViewer.doOperation(13);
                    }
                    event.doit = false;
                }
            }
        });
    }

    public SourceViewer getSourceViewer() {
        return this._sourceViewer;
    }

    public boolean isAssistSessionActive() {
        return this.expressionFieldConfiguration.isAssistSessionActive();
    }

    public void setMissingLinkAnnotations(List<Position> positions) {
        for (Position p : positions) {
            Annotation annotation = new Annotation(false);
            annotation.setType(MISSING_LINK);
            annotation.setText("No link to this variable");
            this._annotationModel.addAnnotation(annotation, p);
        }
    }

    public void setNoSuchVariableAnnotations(List<Position> positions) {
        for (Position p : positions) {
            Annotation annotation = new Annotation(false);
            annotation.setType(NO_SUCH_VARIABLE);
            annotation.setText("No such variable in model");
            this._annotationModel.addAnnotation(annotation, p);
        }
    }

    public void setSyntaxError(SyntaxError syntaxError) {
        Annotation annotation = new Annotation(false);
        annotation.setType(syntaxError.getType());
        annotation.setText(syntaxError.getMessage());
        Position p = new Position(syntaxError.getStart(this._document), syntaxError.getOffset(this._document));
        this._annotationModel.addAnnotation(annotation, p);
    }

    public void resetAnnotations() {
        this._annotationModel.removeAllAnnotations();
    }

    public void setExpression(String expression) {
        this._document.set(expression);
        this.oldExpression = expression;
    }

    public String getExpression() {
        return this._document.get();
    }

    public Point getSelection() {
        return this._sourceViewer.getSelectedRange();
    }

    public void setSelection(int selection) {
        this._sourceViewer.setSelectedRange(selection, 0);
    }

    public IDocument getDocument() {
        return this._document;
    }

    public void focus() {
        this._sourceViewer.getTextWidget().forceFocus();
    }

    public boolean emptyValueAllowed() {
        return this.expressionFieldConfiguration.allowEmpty;
    }
}

