/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionField;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.properties.widgets.expressions.IExpression;

public class DelayExpression
implements IExpression {
    private ExpressionField equation;
    private ExpressionField delayTime;
    private ExpressionField initialValue;
    private ExpressionField lastSelectedText;
    private Spinner order;
    private final ExpressionWidgetInput input;
    private Resource expression;
    private Combo delayTypeCombo;

    public DelayExpression(ExpressionWidgetInput input) {
        this.input = input;
        this.expression = input.expression;
    }

    @Override
    public void createExpressionFields(Composite parent, final Map<String, Object> data, Table allowedVariables) {
        GridLayoutFactory.fillDefaults().numColumns(5).applyTo(parent);
        String eq = data.get("equation") != null ? (String)data.get("equation") : "";
        String dt = data.get("delayTime") != null ? (String)data.get("delayTime") : "";
        String iv = data.get("initialValue") != null ? (String)data.get("initialValue") : "";
        int o = data.get("order") != null ? (Integer)data.get("order") : 3;
        Label l = new Label(parent, 0);
        l.setText("Expression");
        this.equation = new ExpressionField(parent, 2048, allowedVariables, true, this.input);
        this.equation.setExpression(eq);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, true).applyTo((Control)this.equation);
        this.equation.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DelayExpression.this.lastSelectedText = DelayExpression.this.equation;
            }
        });
        l = new Label(parent, 0);
        l.setText("Delay time");
        this.delayTime = new ExpressionField(parent, 2048, allowedVariables, true, this.input);
        this.delayTime.setExpression(dt);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, true).applyTo((Control)this.delayTime);
        this.delayTime.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DelayExpression.this.lastSelectedText = DelayExpression.this.delayTime;
            }
        });
        l = new Label(parent, 0);
        l.setText("Initial value");
        this.initialValue = new ExpressionField(parent, 2048, allowedVariables, true, true, this.input);
        this.initialValue.setExpression(iv);
        GridDataFactory.fillDefaults().span(4, 1).grab(true, true).applyTo((Control)this.initialValue);
        this.initialValue.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DelayExpression.this.lastSelectedText = DelayExpression.this.initialValue;
            }
        });
        l = new Label(parent, 0);
        l.setText("Order");
        this.order = new Spinner(parent, 2048);
        this.order.setMinimum(1);
        this.order.setSelection(o);
        this.order.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelayExpression.this.save(DelayExpression.this.expression, data);
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.order);
        l = new Label(parent, 0);
        l.setText("Delay type");
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000000).applyTo((Control)l);
        this.delayTypeCombo = new Combo(parent, 2060);
        this.delayTypeCombo.add("Material");
        this.delayTypeCombo.add("Information");
        GridDataFactory.fillDefaults().applyTo((Control)this.delayTypeCombo);
        try {
            boolean isInformationDelay = (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    return graph.hasStatement(DelayExpression.this.expression, sr.DelayExpression_isInformationDelay, DelayExpression.this.expression);
                }
            });
            this.delayTypeCombo.select(isInformationDelay ? 1 : 0);
        }
        catch (DatabaseException e1) {
            this.delayTypeCombo.select(0);
            e1.printStackTrace();
        }
        this.delayTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DelayExpression.this.save(DelayExpression.this.expression, data);
            }
        });
        this.lastSelectedText = this.equation;
    }

    @Override
    public void focus() {
        this.lastSelectedText.setFocus();
    }

    @Override
    public List<ExpressionField> getExpressionFields() {
        return Arrays.asList(this.equation, this.delayTime, this.initialValue);
    }

    @Override
    public void readData(final Resource expression, Map<String, Object> data) {
        class Auxiliary {
            String equation;
            String delayTime;
            String initialValue;
            Integer order;
            Boolean isInformationDelay;

            Auxiliary() {
            }
        }
        Auxiliary results = null;
        try {
            results = (Auxiliary)Simantics.getSession().syncRequest((Read)new Read<Auxiliary>(){

                public Auxiliary perform(ReadGraph graph) throws DatabaseException {
                    Auxiliary results = new Auxiliary();
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    if (expression != null && graph.isInstanceOf(expression, sr.DelayExpression)) {
                        results.equation = (String)graph.getPossibleRelatedValue(expression, sr.DelayExpression_expression);
                        results.delayTime = (String)graph.getPossibleRelatedValue(expression, sr.DelayExpression_delayTime);
                        results.initialValue = (String)graph.getPossibleRelatedValue(expression, sr.DelayExpression_initialValue);
                        results.order = (Integer)graph.getPossibleRelatedValue(expression, sr.DelayExpression_order);
                        results.isInformationDelay = graph.hasStatement(expression, sr.DelayExpression_isInformationDelay, expression);
                    } else {
                        results.equation = "";
                        results.delayTime = "";
                        results.order = 1;
                        results.isInformationDelay = false;
                    }
                    return results;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (results.equation != null) {
            data.put("equation", results.equation);
        }
        if (results.delayTime != null) {
            data.put("delayTime", results.delayTime);
        }
        if (results.initialValue != null) {
            data.put("initialValue", results.initialValue);
        }
        if (results.order != null) {
            data.put("order", results.order);
        }
        if (results.isInformationDelay != null) {
            data.put("isInformationDelay", results.isInformationDelay);
        }
    }

    @Override
    public void replaceSelection(String var) {
        if (this.lastSelectedText != null) {
            IDocument doc = this.lastSelectedText.getDocument();
            try {
                Point selection = this.lastSelectedText.getSelection();
                doc.replace(selection.x, selection.y, var);
                this.lastSelectedText.setSelection(selection.x + var.length());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void save(Resource expr, Map<String, Object> data) {
        this.expression = expr;
        final String currentEquation = this.equation.getExpression();
        final String currentDelayTime = this.delayTime.getExpression();
        final String currentInitialValue = this.initialValue.getExpression();
        final Integer currentOrder = this.order.getSelection();
        final Boolean currentIsInformationDelay = this.delayTypeCombo.getSelectionIndex() == 1;
        String oldEquation = (String)data.get("equation");
        String oldDelayTime = (String)data.get("delayTime");
        String oldInitialValue = (String)data.get("initialValue");
        Integer oldOrder = (Integer)data.get("order");
        Boolean oldIsInformationDelay = (Boolean)data.get("isInformationDelay");
        if (!(oldEquation != null && oldDelayTime != null && oldOrder != null && oldInitialValue != null && oldIsInformationDelay != null && oldEquation.equals(currentEquation) && oldDelayTime.equals(currentDelayTime) && oldOrder.equals(currentOrder) && oldInitialValue.equals(currentInitialValue) && oldIsInformationDelay.equals(currentIsInformationDelay))) {
            data.putAll(data);
            data.put("equation", currentEquation);
            data.put("delayTime", currentDelayTime);
            data.put("initialValue", currentInitialValue);
            data.put("order", currentOrder);
            data.put("isInformationDelay", currentIsInformationDelay);
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph g) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                    if (!g.isInstanceOf(DelayExpression.this.expression, sr.DelayExpression)) {
                        final Resource newExpression = GraphUtils.create2((WriteGraph)g, (Resource)sr.DelayExpression, (Object[])new Object[0]);
                        String arrayRange = (String)g.getPossibleRelatedValue(DelayExpression.this.expression, sr.Expression_arrayRange, (Binding)Bindings.STRING);
                        if (arrayRange != null) {
                            g.claimLiteral(newExpression, sr.Expression_arrayRange, (Object)arrayRange);
                        }
                        final Resource variable = g.getPossibleObject(DelayExpression.this.expression, l0.PartOf);
                        Resource ownerList = g.getPossibleObject(variable, sr.Variable_expressionList);
                        ListUtils.replace((WriteGraph)g, (Resource)ownerList, (Resource)DelayExpression.this.expression, (Resource)newExpression);
                        g.deny(DelayExpression.this.expression, l0.PartOf);
                        g.claim(newExpression, l0.PartOf, variable);
                        VirtualGraph runtime = (VirtualGraph)g.getService(VirtualGraph.class);
                        g.syncRequest((Write)new WriteRequest(runtime){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                if (graph.hasStatement(variable, sr.IndependentVariable_activeExpression)) {
                                    graph.deny(variable, sr.IndependentVariable_activeExpression);
                                }
                                graph.claim(variable, sr.IndependentVariable_activeExpression, newExpression);
                            }
                        });
                        DelayExpression.this.expression = newExpression;
                    }
                    g.claimLiteral(DelayExpression.this.expression, sr.DelayExpression_expression, (Object)currentEquation);
                    g.claimLiteral(DelayExpression.this.expression, sr.DelayExpression_delayTime, (Object)currentDelayTime);
                    g.claimLiteral(DelayExpression.this.expression, sr.DelayExpression_initialValue, (Object)currentInitialValue);
                    g.claimLiteral(DelayExpression.this.expression, sr.DelayExpression_order, (Object)currentOrder);
                    if (currentIsInformationDelay.booleanValue()) {
                        g.claim(DelayExpression.this.expression, sr.DelayExpression_isInformationDelay, DelayExpression.this.expression);
                    } else {
                        g.deny(DelayExpression.this.expression, sr.DelayExpression_isInformationDelay, DelayExpression.this.expression);
                    }
                    g.markUndoPoint();
                    CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
                    g.addMetadata((Metadata)cm.add("Set delay expression"));
                }
            });
        }
    }

    @Override
    public void updateData(Map<String, Object> data) {
        if (this.equation != null && this.equation.getExpression() != null) {
            data.put("equation", this.equation.getExpression());
        }
        if (this.delayTime != null && this.delayTime.getExpression() != null) {
            data.put("delayTime", this.delayTime.getExpression());
        }
        if (this.initialValue != null && this.initialValue.getExpression() != null) {
            data.put("initialValue", this.initialValue.getExpression());
        }
        if (this.order != null) {
            data.put("order", this.order.getSelection());
        }
        if (this.delayTypeCombo != null) {
            data.put("isInformationDelay", this.delayTypeCombo.getSelectionIndex() == 1);
        }
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        this.equation.getSourceViewer().getTextWidget().addKeyListener(listener);
        this.delayTime.getSourceViewer().getTextWidget().addKeyListener(listener);
        this.initialValue.getSourceViewer().getTextWidget().addKeyListener(listener);
    }

    @Override
    public void addModifyListener(ModifyListener listener) {
        this.equation.getSourceViewer().getTextWidget().addModifyListener(listener);
        this.delayTime.getSourceViewer().getTextWidget().addModifyListener(listener);
        this.initialValue.getSourceViewer().getTextWidget().addModifyListener(listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.equation.getSourceViewer().getTextWidget().addFocusListener(listener);
        this.delayTime.getSourceViewer().getTextWidget().addFocusListener(listener);
        this.initialValue.getSourceViewer().getTextWidget().addFocusListener(listener);
    }

    @Override
    public void addVerifyKeyListener(VerifyKeyListener listener) {
        this.equation.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
        this.delayTime.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
        this.initialValue.getSourceViewer().getTextWidget().addVerifyKeyListener(listener);
    }

    @Override
    public IUndoManager getUndoManager() {
        return null;
    }
}

