/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.arrays;

import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Combo;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.widgets.ArrayExpressionCombo;
import org.simantics.sysdyn.ui.properties.widgets.ExpressionWidget;
import org.simantics.sysdyn.ui.utils.VariableNameValidator;
import org.simantics.utils.ui.ISelectionUtils;

public class NameAndArrayRangeModifyListener
extends ComboModifyListenerImpl<Resource>
implements Widget {
    Resource lastExpression;
    ExpressionWidget expressionWidget;
    ArrayExpressionCombo arrayExpressionCombo;
    Object lastInput;

    public NameAndArrayRangeModifyListener(WidgetSupport support, ExpressionWidget expressionWidget, ArrayExpressionCombo arrayExpressionCombo) {
        support.register((Widget)this);
        this.expressionWidget = expressionWidget;
        this.arrayExpressionCombo = arrayExpressionCombo;
    }

    public void setInput(ISessionContext context, Object input) {
        super.setInput(context, input);
        this.lastInput = input;
    }

    public void modifyText(TrackedModifyEvent e) {
        Combo combo = (Combo)e.getWidget();
        LinkedHashMap data = (LinkedHashMap)combo.getData();
        Resource activeExpression = null;
        try {
            final Object input = this.lastInput;
            activeExpression = (Resource)Simantics.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Resource variable = (Resource)ISelectionUtils.filterSingleSelection((Object)input, Resource.class);
                    return graph.getPossibleObject(variable, SysdynResource.getInstance((ReadGraph)graph).IndependentVariable_activeExpression);
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        Resource expression = (Resource)data.get(combo.getText());
        if (expression != null) {
            this.lastExpression = expression;
            this.arrayExpressionCombo.setLastSelectedIndex(combo.getSelectionIndex());
        } else {
            for (Object key : data.keySet()) {
                int index;
                int n = index = this.arrayExpressionCombo.getLastSelectedIndex() < 0 ? 0 : this.arrayExpressionCombo.getLastSelectedIndex();
                if ((Integer)combo.getData((String)key) != index) continue;
                this.lastExpression = (Resource)data.get(key);
                break;
            }
        }
        if (this.lastExpression != null && !this.lastExpression.equals(activeExpression) && this.expressionWidget != null) {
            this.expressionWidget.save();
        }
        super.modifyText(e);
    }

    public void applyText(WriteGraph graph, final Resource variable, String text) throws DatabaseException {
        String originalName;
        StringTokenizer st = new StringTokenizer(text, "[]");
        String newName = st.nextToken();
        String range = null;
        if (st.hasMoreTokens()) {
            range = st.nextToken();
        }
        if (!(originalName = (String)graph.getRelatedValue(variable, Layer0.getInstance((ReadGraph)graph).HasName)).equals(newName)) {
            Resource configuration = graph.getPossibleObject(variable, Layer0.getInstance((ReadGraph)graph).PartOf);
            new VariableNameValidator().renameInAllEquations(graph, configuration, originalName, newName);
            graph.claimLiteral(variable, Layer0.getInstance((ReadGraph)graph).HasName, (Object)newName);
        }
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (range != null && this.lastExpression != null) {
            String oldRange = (String)graph.getPossibleRelatedValue(this.lastExpression, sr.Expression_arrayRange);
            if (oldRange == null || !range.equals(oldRange)) {
                graph.claimLiteral(this.lastExpression, sr.Expression_arrayRange, (Object)("[" + range + "]"));
            }
        } else if (range == null && this.lastExpression != null && graph.hasStatement(this.lastExpression, sr.Expression_arrayRange)) {
            graph.deny(this.lastExpression, sr.Expression_arrayRange);
        }
        Resource activeExpression = graph.getPossibleObject(variable, sr.IndependentVariable_activeExpression);
        if (this.lastExpression != null && !this.lastExpression.equals(activeExpression)) {
            VirtualGraphSupport support = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            final Session session = graph.getSession();
            session.asyncRequest((Write)new WriteRequest(support.getWorkspacePersistent("expressions")){

                public void perform(WriteGraph graph) throws DatabaseException {
                    VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                    session.asyncRequest((Write)new WriteRequest(runtime){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                            if (graph.hasStatement(variable, sr.IndependentVariable_activeExpression)) {
                                graph.deny(variable, sr.IndependentVariable_activeExpression);
                            }
                            graph.claim(variable, sr.IndependentVariable_activeExpression, (this).NameAndArrayRangeModifyListener.this.lastExpression);
                        }
                    });
                }
            });
        }
    }
}

