/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.WidgetImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.datastructures.Quad;

public class ValveOrientationGroup
extends WidgetImpl {
    Group group;
    Button vertical;
    Button horizontal;

    public ValveOrientationGroup(Composite parent, ISessionContext context, WidgetSupport support, int style) {
        super(support);
        this.group = new Group(parent, 0);
        this.group.setText("Valve orientation");
        GridDataFactory.fillDefaults().applyTo((Control)this.group);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.group);
        this.horizontal = new Button((Composite)this.group, support, 16);
        this.horizontal.setText("Horizontal");
        this.horizontal.setSelectionFactory((ReadFactory)new OrientationSelectionFactory(this.horizontal, "http://www.simantics.org/Sysdyn-1.1/Horizontal", true));
        this.horizontal.addSelectionListener((SelectionListener)new OrientationSelectionListener(context, "http://www.simantics.org/Sysdyn-1.1/Horizontal"));
        this.vertical = new Button((Composite)this.group, support, 16);
        this.vertical.setText("Vertical");
        this.vertical.setSelectionFactory((ReadFactory)new OrientationSelectionFactory(this.vertical, "http://www.simantics.org/Sysdyn-1.1/Vertical"));
        this.vertical.addSelectionListener((SelectionListener)new OrientationSelectionListener(context, "http://www.simantics.org/Sysdyn-1.1/Vertical"));
    }

    public void setInput(ISessionContext context, Object input) {
        this.horizontal.setInput(context, input);
        this.vertical.setInput(context, input);
    }

    public Control getControl() {
        return this.group;
    }

    private class OrientationSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        boolean defaultSelected;
        String uri;
        Button button;

        public OrientationSelectionFactory(Button button, String uri) {
            this(button, uri, false);
        }

        public OrientationSelectionFactory(Button button, String uri, boolean defaultSelected) {
            this.uri = uri;
            this.defaultSelected = defaultSelected;
            this.button = button;
        }

        public Object getIdentity(Object inputContents) {
            return new Quad((Object)this.button, (Object)this.uri, (Object)this.defaultSelected, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource valve) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(valve, sr.Valve)) {
                return Boolean.FALSE;
            }
            Resource symbol = graph.getPossibleObject(valve, mr.ComponentToElement);
            if (symbol == null) {
                return Boolean.FALSE;
            }
            Resource orientation = graph.getPossibleObject(symbol, sr.ValveSymbol_orientation);
            if (orientation == null) {
                return this.defaultSelected;
            }
            return orientation.equals(graph.getResource(this.uri));
        }
    }

    private class OrientationSelectionListener
    extends SelectionListenerImpl<Resource> {
        String uri;

        public OrientationSelectionListener(ISessionContext context, String uri) {
            super(context);
            this.uri = uri;
        }

        public void apply(WriteGraph graph, Resource valve) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            if (!graph.isInstanceOf(valve, sr.Valve)) {
                return;
            }
            Resource symbol = graph.getPossibleObject(valve, mr.ComponentToElement);
            if (symbol == null) {
                return;
            }
            if (graph.hasStatement(symbol, sr.ValveSymbol_orientation)) {
                graph.deny(symbol, sr.ValveSymbol_orientation);
            }
            graph.claim(symbol, sr.ValveSymbol_orientation, graph.getResource(this.uri));
            if (graph.hasStatement(symbol, sr.ValveSymbol_textLocation)) {
                graph.deny(symbol, sr.ValveSymbol_textLocation);
            }
            if (sr.Vertical.equals(graph.getResource(this.uri))) {
                graph.claim(symbol, sr.ValveSymbol_textLocation, sr.Right);
            }
        }
    }
}

