/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.operation.Layer0X;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.ui.ISelectionUtils;

public class EquivalentUnitsWidget
implements Widget {
    Resource model = null;
    Button unitEquivalents;

    public EquivalentUnitsWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.unitEquivalents = new Button(parent, support, style |= 0x20);
        this.unitEquivalents.setText("Unit equivalents");
        this.unitEquivalents.getWidget().setToolTipText("Supported equivalent units:\n$, $s, dollar, dollars, usd\n\u20ac, \u20acs, eur, euro, euros, e, ecu\n\ufffd, \ufffds, pound, pounds, gbp\nUnit, Units\nPerson, People, Persons\nsecond, seconds, sec, s\nminute, minutes, min\nhour, hours, h, hr\nday, days, d\nmonth, months, mon, mth, mo, mos\nyear, years, a, y, yr");
    }

    public void setInput(ISessionContext context, Object input) {
        Resource resource;
        ISelection selection;
        if (input instanceof ISelection && (selection = (ISelection)input) instanceof IStructuredSelection && (resource = (Resource)ISelectionUtils.filterSingleSelection((Object)selection, Resource.class)) != null) {
            this.model = resource;
        }
        if (this.model == null) {
            return;
        }
        try {
            context.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    final Resource unitIssueSource = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(EquivalentUnitsWidget.this.model, Layer0X.getInstance((ReadGraph)graph).Activates, sr.Validations_Units_UnitIssueSource));
                    IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
                    final Boolean issueSource_active = (Boolean)graph.getPossibleRelatedValue(unitIssueSource, ISSUE.IssueSource_active, (Binding)Bindings.BOOLEAN);
                    Boolean result = false;
                    if (unitIssueSource != null) {
                        result = (Boolean)graph.getPossibleRelatedValue(unitIssueSource, sr.Validations_Units_UnitIssueSource_allowEquivalents, (Binding)Bindings.BOOLEAN);
                    }
                    final boolean enable = result;
                    final org.eclipse.swt.widgets.Button button = EquivalentUnitsWidget.this.getWidget();
                    button.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (button.isDisposed()) {
                                return;
                            }
                            EquivalentUnitsWidget.this.getWidget().setEnabled(unitIssueSource != null && issueSource_active != false);
                            if (Boolean.TRUE.equals(enable)) {
                                button.setSelection(true);
                            } else {
                                button.setSelection(false);
                            }
                        }
                    });
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.unitEquivalents.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource model) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Resource unitIssueSource = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(model, Layer0X.getInstance((ReadGraph)graph).Activates, sr.Validations_Units_UnitIssueSource));
                if (unitIssueSource == null) {
                    return;
                }
                Boolean result = (Boolean)graph.getPossibleRelatedValue(unitIssueSource, sr.Validations_Units_UnitIssueSource_allowEquivalents, (Binding)Bindings.BOOLEAN);
                if (result == null) {
                    result = false;
                }
                graph.claimLiteral(unitIssueSource, sr.Validations_Units_UnitIssueSource_allowEquivalents, (Object)Boolean.FALSE.equals(result));
            }
        });
    }

    public org.eclipse.swt.widgets.Button getWidget() {
        return this.unitEquivalents.getWidget();
    }
}

