/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets;

import java.awt.Font;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPreferences;
import org.simantics.sysdyn.ui.properties.widgets.FontModifyListener;
import org.simantics.sysdyn.ui.properties.widgets.FontSelectionComposite;
import org.simantics.utils.ui.gfx.ColorImageDescriptor;

public class CustomFontDialog
extends Dialog {
    private Map<String, Integer> systemColors = CustomFontDialog.createColorMap();
    private FontData resultSWTFontData;
    private Font awtFont;
    private Font resultAWTFont;
    private java.awt.Color color;
    private java.awt.Color resultAWTColor;
    private FontSelectionComposite vpc;
    private TableCombo tc;
    private String example = "Example";
    private Label sample;
    private Group sampleGroup;
    private RGB rgb;
    private LocalResourceManager resourceManager;

    protected static Map<String, Integer> createColorMap() {
        LinkedHashMap<String, Integer> colors = new LinkedHashMap<String, Integer>();
        colors.put("Black", 2);
        colors.put("White", 1);
        colors.put("Blue", 9);
        colors.put("Dark Blue", 10);
        colors.put("Red", 3);
        colors.put("Dark Red", 4);
        colors.put("Yellow", 7);
        colors.put("Dark Yellow", 8);
        colors.put("Gray", 15);
        colors.put("Dark Gray", 16);
        colors.put("Green", 5);
        colors.put("Dark Green", 6);
        colors.put("Cyan", 13);
        colors.put("Dark Cyan", 14);
        colors.put("Magenta", 11);
        colors.put("Dark Magenta", 12);
        return colors;
    }

    public CustomFontDialog(Shell parentShell, String example) {
        super(parentShell);
        if (example != null) {
            this.example = example;
        }
    }

    public void setAWTFont(Font awtFont) {
        this.awtFont = awtFont;
        this.resultAWTFont = awtFont;
    }

    public Font getAWTFont() {
        return this.resultAWTFont;
    }

    public FontData getSWTFontData() {
        return this.resultSWTFontData;
    }

    public void setColor(java.awt.Color color) {
        this.color = color;
        this.resultAWTColor = color;
    }

    public java.awt.Color getAWTColor() {
        return this.resultAWTColor;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    protected void createFontChooser(Composite parent) {
        this.vpc = new FontSelectionComposite(parent, 0);
        this.vpc.setFont(this.awtFont, false);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.vpc);
        this.vpc.addFontModifiedListener(new FontModifyListener(){

            @Override
            public void swtFontDataChanged(FontData fd) {
                CustomFontDialog.this.sample.setFont(CustomFontDialog.this.resourceManager.createFont(FontDescriptor.createFrom((FontData)fd)));
                CustomFontDialog.this.sampleGroup.layout();
            }

            @Override
            public void awtFontChanged(Font font) {
            }
        });
    }

    protected void createColorChooser(Composite parent) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        Composite colorComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)colorComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(colorComposite);
        Label label = new Label(colorComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Color: ");
        this.tc = new TableCombo(colorComposite, 2056);
        GridDataFactory.fillDefaults().hint(170, -1).applyTo((Control)this.tc);
        this.tc.defineColumns(2);
        this.tc.setDisplayColumnIndex(1);
        this.tc.setToolTipText("this is tooltip");
        this.createColorItems(this.tc.getTable());
        if (this.color != null) {
            int i = 0;
            while (i < this.tc.getTable().getItemCount()) {
                TableItem ti = this.tc.getTable().getItem(i);
                RGB rgb = (RGB)ti.getData();
                if (rgb.red == this.color.getRed() && rgb.green == this.color.getGreen() && rgb.blue == this.color.getBlue()) {
                    this.tc.setText(ti.getText(1));
                    this.tc.setForeground(this.resourceManager.createColor(rgb));
                    break;
                }
                ++i;
            }
        }
        this.tc.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selection = CustomFontDialog.this.tc.getTable().getSelection();
                if (selection.length == 1) {
                    CustomFontDialog.this.rgb = (RGB)selection[0].getData();
                    Color swtColor = CustomFontDialog.this.resourceManager.createColor(CustomFontDialog.this.rgb);
                    CustomFontDialog.this.sample.setForeground(swtColor);
                    CustomFontDialog.this.tc.setForeground(swtColor);
                }
                CustomFontDialog.this.tc.getTextControl().setSelection(0);
                CustomFontDialog.this.tc.getParent().forceFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createSampleArea(Composite parent) {
        this.sampleGroup = new Group(parent, 0);
        this.sampleGroup.setText("Sample");
        GridDataFactory.fillDefaults().hint(-1, 70).applyTo((Control)this.sampleGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)this.sampleGroup);
        this.sample = new Label((Composite)this.sampleGroup, 0);
        this.sample.setText(this.example);
        if (this.awtFont != null) {
            this.sample.setFont(this.resourceManager.createFont(FontDescriptor.createFrom((FontData)CustomFontDialog.toSwtFontData(this.awtFont))));
        }
        if (this.rgb != null) {
            this.sample.setForeground(this.resourceManager.createColor(this.rgb));
        }
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.sample);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.getShell().setText("Choose Font");
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(composite);
        if (this.color != null) {
            this.rgb = new RGB(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }
        this.createFontChooser(composite);
        this.createColorChooser(composite);
        this.createSampleArea(composite);
        this.setDialogLocationToMonitorCenter();
        return composite;
    }

    protected void cancelPressed() {
        this.resultAWTFont = this.awtFont;
        this.resultAWTColor = this.color;
        if (this.resultAWTFont != null) {
            this.resultSWTFontData = CustomFontDialog.toSwtFontData(this.resultAWTFont);
        }
        this.setReturnCode(1);
        this.close();
    }

    protected void okPressed() {
        this.resultAWTFont = this.vpc.getAWTFont();
        this.resultSWTFontData = CustomFontDialog.toSwtFontData(this.resultAWTFont);
        TableItem[] selection = this.tc.getTable().getSelection();
        if (selection.length == 1) {
            RGB rgb = (RGB)selection[0].getData();
            this.resultAWTColor = new java.awt.Color(rgb.red, rgb.green, rgb.blue);
        }
        this.setReturnCode(0);
        this.close();
    }

    protected void setDialogLocationToMonitorCenter() {
        Rectangle monitorArea = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        Rectangle shellArea = this.getShell().getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        this.getShell().setLocation(x, y);
    }

    protected static FontData toSwtFontData(Font font) {
        FontData fontData = new FontData();
        fontData.setName(font.getFontName());
        fontData.setStyle(font.getStyle());
        fontData.setHeight(font.getSize());
        return fontData;
    }

    protected void createColorItems(Table table) {
        Display display = Display.getCurrent();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)SysdynDiagramPreferences.ARROW_COLOR);
        Image image = this.resourceManager.createImage((ImageDescriptor)new ColorImageDescriptor(color.red, color.green, color.blue, 25, 15, false));
        TableItem ti = new TableItem(table, 0);
        ti.setImage(0, image);
        ti.setText(1, "Default Arrow");
        ti.setForeground(display.getSystemColor(2));
        ti.setData((Object)color);
        for (String text : this.systemColors.keySet()) {
            int code = this.systemColors.get(text);
            color = display.getSystemColor(code).getRGB();
            image = this.resourceManager.createImage((ImageDescriptor)new ColorImageDescriptor(color.red, color.green, color.blue, 25, 15, false));
            ti = new TableItem(table, 0);
            ti.setImage(0, image);
            ti.setText(1, text);
            ti.setForeground(display.getSystemColor(2));
            ti.setData((Object)color);
        }
    }
}

