/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.modelica;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modelica.ModelicaManager;
import org.simantics.sysdyn.modelica.ModelicaWriter;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.LoadRepresentation;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.representation.utils.RepresentationUtils;
import org.simantics.sysdyn.ui.modelica.ModelicaSourceViewerConfiguration;
import org.simantics.ui.workbench.ResourceEditorInput;

public class SysdynModelicaEditor
extends TextEditor {
    AnnotationModel annotationModel = new AnnotationModel();
    AnnotationPainter apainter;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        try {
            Configuration configuration = LoadRepresentation.loadConfiguration((Session)Simantics.getSession(), (Resource)((ResourceEditorInput)input).getResource());
            this.setPartName(configuration.getLabel());
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public SysdynModelicaEditor() {
        this.showOverviewRuler();
        this.setDocumentProvider((IDocumentProvider)new AbstractDocumentProvider(){

            protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
                return SysdynModelicaEditor.this.annotationModel;
            }

            protected IDocument createDocument(Object element) throws CoreException {
                try {
                    Configuration configuration = LoadRepresentation.loadConfiguration((Session)Simantics.getSession(), (Resource)((ResourceEditorInput)element).getResource());
                    HashSet<Configuration> configurations = new HashSet<Configuration>();
                    configurations.add(configuration);
                    SysdynModelicaEditor.this.getConfigurations(configuration, configurations);
                    String version = ModelicaManager.getDefaultOMVersion();
                    return new Document(ModelicaWriter.write(configurations, (double)configuration.getModel().getStartTime(), (double)configuration.getModel().getStopTime(), (double)configuration.getModel().getSimulationStepLength(), (boolean)RepresentationUtils.isGameExperimentActive(), (String)version));
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                    throw new CoreException(STATUS_ERROR);
                }
            }

            protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            }

            protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }

            public boolean isModifiable(Object element) {
                return false;
            }

            public boolean isReadOnly(Object element) {
                return true;
            }
        });
        this.setSourceViewerConfiguration(new ModelicaSourceViewerConfiguration());
    }

    private void getConfigurations(Configuration configuration, Set<Configuration> configurations) {
        for (IElement e : configuration.getElements()) {
            if (!(e instanceof Module)) continue;
            ModuleType mt = ((Module)e).getType();
            configurations.add(mt.getConfiguration());
            this.getConfigurations(mt.getConfiguration(), configurations);
        }
    }

    protected void createActions() {
        super.createActions();
        PaintManager paintManager = new PaintManager((ITextViewer)this.getSourceViewer());
        MatchingCharacterPainter matchingCharacterPainter = new MatchingCharacterPainter(this.getSourceViewer(), (ICharacterPairMatcher)new DefaultCharacterPairMatcher(new char[]{'(', ')', '{', '}', '[', ']'}));
        matchingCharacterPainter.setColor(new Color((Device)Display.getCurrent(), new RGB(160, 160, 160)));
        paintManager.addPainter((IPainter)matchingCharacterPainter);
    }
}

