/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.newComponents;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.ui.AdaptionUtils;

public class NewEnumerationNodeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        final Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)sel, Resource.class);
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                g.markUndoPoint();
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                Resource configuration = null;
                if (g.isInstanceOf(resource, sr.Configuration)) {
                    configuration = resource;
                } else if (g.isInheritedFrom(resource, sr.ModuleSymbol)) {
                    Resource module = g.getPossibleObject(resource, ModelingResources.getInstance((ReadGraph)g).SymbolToComponentType);
                    configuration = g.getPossibleObject(module, StructuralResource2.getInstance((ReadGraph)g).IsDefinedBy);
                } else {
                    Resource instanceOf = g.getSingleObject(resource, l0.InstanceOf);
                    if (g.isInheritedFrom(instanceOf, sr.Module)) {
                        configuration = g.getPossibleObject(instanceOf, StructuralResource2.getInstance((ReadGraph)g).IsDefinedBy);
                    } else {
                        return;
                    }
                }
                String name = NameUtils.findFreshName((ReadGraph)g, (String)"Enum", (Resource)configuration, (Resource)l0.ConsistsOf, (String)"%s%d");
                GraphUtils.create2((WriteGraph)g, (Resource)sr.Enumeration, (Object[])new Object[]{l0.HasName, name, sr.Enumeration_enumerationIndexList, ListUtils.create((WriteGraph)g, new ArrayList()), l0.PartOf, configuration});
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)g, (String)("Created new Enumeration " + name + " to " + g.getRelatedValue2(configuration, l0.HasLabel, (Binding)Bindings.STRING)));
            }
        });
        return null;
    }
}

