/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.simantics.jfreechart.ChartPanel;
import org.simantics.sysdyn.ui.Activator;

public class ChartPanelOrientationHandler
extends AbstractHandler
implements IElementUpdater {
    private static String COMMAND = "org.simantics.sysdyn.ui.chartPanelOrientation";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getActivePart();
        if (part instanceof ChartPanel) {
            String orientation;
            IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("CHART_PANEL_SETTINGS");
            if (settings == null) {
                settings = Activator.getDefault().getDialogSettings().addNewSection("CHART_PANEL_SETTINGS");
            }
            if ((orientation = settings.get("CHART_PANEL_ORIENTATION")) == null) {
                settings.put("CHART_PANEL_ORIENTATION", "CHART_PANEL_ORIENTATION_HORIZONTAL");
            }
            orientation = "CHART_PANEL_ORIENTATION_VERTICAL".equals(orientation) ? "CHART_PANEL_ORIENTATION_HORIZONTAL" : "CHART_PANEL_ORIENTATION_VERTICAL";
            settings.put("CHART_PANEL_ORIENTATION", orientation);
            ((ChartPanel)part).setOrientation(orientation);
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            commandService.refreshElements(COMMAND, null);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        if (parameters == null) {
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("CHART_PANEL_SETTINGS");
        if (settings == null) {
            return;
        }
        String orientation = settings.get("CHART_PANEL_ORIENTATION");
        if (orientation == null) {
            return;
        }
        if ("CHART_PANEL_ORIENTATION_HORIZONTAL".equals(orientation)) {
            element.setIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/page_white_text.png")));
            element.setTooltip("Vertical Orientation");
        } else if ("CHART_PANEL_ORIENTATION_VERTICAL".equals(orientation)) {
            element.setIcon(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/page_white_text_width.png")));
            element.setTooltip("Horizontal Orientation");
        }
    }
}

