/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.FunctionImpl5;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.handlers.FindSearchTrim;
import org.simantics.sysdyn.ui.utils.SysdynWorkbenchUtils;
import org.simantics.workbench.search.NameAndTypeRow;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;
import org.simantics.workbench.search.SearchResultRow;
import org.simantics.workbench.search.Searching;

public class ModulesSearchFunction
extends FunctionImpl5<IProgressMonitor, ReadGraph, Resource, SearchQuery, Integer, SearchResult> {
    private final int MAX_RESULTS = 50000;

    public SearchResult apply(IProgressMonitor monitor, ReadGraph graph, Resource model, SearchQuery query, Integer maxResults) {
        try {
            String origQuery = query.getOriginalQuery();
            SearchQuery wildcardedQuery = !origQuery.isEmpty() ? query.withOriginalQuery("*" + origQuery + "*") : query.withOriginalQuery("*");
            String filteredQuery = wildcardedQuery.escaped(false).getQuery(new String[]{"Name", "Types"});
            Collection results = Searching.performSearch((ReadGraph)graph, (Resource)Layer0X.getInstance((ReadGraph)graph).Dependencies, (Resource)model, (String)filteredQuery, (int)50000);
            if (!query.getSearchParams().contains("@Current_diagram")) {
                return ModulesSearchFunction.generateSearchResults(graph, results, FindSearchTrim.Scope.ALL_MODELS);
            }
            return ModulesSearchFunction.generateSearchResults(graph, results, FindSearchTrim.Scope.CURRENT_DIAGRAM);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    private static boolean resourceFoundInCurrentDiagram(ReadGraph graph, Resource diagram) throws ManyObjectsForFunctionalRelationException, ServiceException {
        IWorkbenchPage page = SysdynWorkbenchUtils.getActivePageOfEditor();
        DiagramEditor editor = (DiagramEditor)page.getActiveEditor();
        if (editor != null) {
            Resource inputResource = editor.getInputResource();
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
            Resource editorResource = graph.getPossibleObject(inputResource, MOD.DiagramToComposite);
            if (diagram.equalsResource(editorResource)) {
                return true;
            }
        }
        return false;
    }

    private static final SearchResult generateSearchResults(ReadGraph graph, Collection<Map<String, Object>> results, FindSearchTrim.Scope scope) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
        SearchResult result = new SearchResult(NameAndTypeRow.columns);
        HashSet<Resource> processed = new HashSet<Resource>();
        for (Map<String, Object> r : results) {
            Set typeResources;
            Resource resource = (Resource)r.get("Resource");
            if (!graph.isInstanceOf(resource, SYSDYN.IndependentVariable) && !graph.isInstanceOf(resource, SYSDYN.Input) && !graph.isInstanceOf(resource, SYSDYN.Module) || !processed.add(resource) || (typeResources = graph.getTypes(resource)).contains(DIA.Element)) continue;
            Resource parent = (Resource)r.get("Parent");
            if (scope == FindSearchTrim.Scope.CURRENT_DIAGRAM && !ModulesSearchFunction.resourceFoundInCurrentDiagram(graph, parent)) continue;
            String name = (String)r.get("Name");
            NameAndTypeRow rst = new NameAndTypeRow();
            rst.resource = NamedResource.of((ReadGraph)graph, (Resource)resource, (String)name);
            rst.parent = NamedResource.of((ReadGraph)graph, (Resource)parent);
            Collection principalTypeResources = graph.getPrincipalTypes(resource);
            if (!typeResources.isEmpty()) {
                rst.types = new ArrayList(typeResources.size());
                rst.principalTypes = new ArrayList(principalTypeResources.size());
                for (Resource t : typeResources) {
                    String typeName = (String)graph.getPossibleRelatedValue(t, L0.HasName, (Binding)Bindings.STRING);
                    if (typeName == null) {
                        typeName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)t);
                    }
                    NamedResource nr = NamedResource.of((ReadGraph)graph, (Resource)t, (String)typeName);
                    rst.types.add(nr);
                    if (!principalTypeResources.contains(t)) continue;
                    rst.principalTypes.add(nr);
                }
            }
            result.addRow((SearchResultRow)rst);
        }
        return result;
    }
}

