/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.ResizeRectangularSceneGraph;
import org.simantics.diagram.elements.TextElementHandler;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.BoundsOutline;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.element.handler.impl.OutlinePick;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.SysdynElementFactory;
import org.simantics.sysdyn.ui.elements.WholeElementTerminals;

public class ShadowFactory
extends SysdynElementFactory {
    private static TextElementHandler shadowHandler = new TextElementHandler(0.0, 0.0, Alignment.LEADING, 0.0, 2.0, 2.0, false);
    private static final TextColorImpl GRAY = new TextColorImpl(Color.GRAY);
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final Image GHOST_IMAGE = new ShapeImage(ShadowFactory.getGhostShape(), null, (Stroke)STROKE, true);

    static Shape getGhostShape() {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-3.0, 3.0);
        ((Path2D)path).quadTo(-3.0, -3.0, 0.0, -3.0);
        ((Path2D)path).quadTo(3.0, -3.0, 3.0, 3.0);
        ((Path2D)path).lineTo(2.0, 2.0);
        ((Path2D)path).lineTo(1.0, 3.0);
        ((Path2D)path).lineTo(0.0, 2.0);
        ((Path2D)path).lineTo(-1.0, 3.0);
        ((Path2D)path).lineTo(-2.0, 2.0);
        path.closePath();
        path.append(new Ellipse2D.Double(-1.25, -1.25, 0.5, 0.5), false);
        path.append(new Ellipse2D.Double(0.75, -1.25, 0.5, 0.5), false);
        return path;
    }

    @Override
    protected ElementClass compileElementClass(Resource elementType, Collection<ObjectTerminal> terminals) {
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{SimpleElementLayers.INSTANCE, OutlinePick.INSTANCE, TextImpl.INSTANCE, GRAY, TextFontImpl.DEFAULT, DefaultTransform.INSTANCE, new StaticObjectAdapter((Object)elementType), new StaticSymbolImpl(GHOST_IMAGE), StaticSymbolImageInitializer.INSTANCE, shadowHandler, BoundsOutline.INSTANCE, ResizeRectangularSceneGraph.INSTANCE, RESIZE_PROPERTY_SETTER, new WholeElementTerminals(terminals)}).setId(ShadowFactory.class.getSimpleName());
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
        String text = null;
        if (component != null) {
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Resource original = graph.getPossibleObject(component, SR.Shadow_original);
            if (original != null) {
                text = "< " + (String)graph.getPossibleRelatedValue(original, l0.HasName) + " >";
            }
        }
        if (text == null) {
            text = "< --- >";
        }
        ElementUtils.setText((IElement)e, (String)text);
        super.getVisualProperties(graph, element, e);
        AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)SYNCHRONIZER);
        e.setHint(ElementHints.KEY_HOVER, (Object)false);
    }
}

