/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.Collection;
import java.util.function.Consumer;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.element.handler.impl.BoundsOutline;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.HoverImpl;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.element.handler.impl.OutlinePick;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.ImageClass;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.g2d.svg.SVGImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.LoopClockwise;
import org.simantics.sysdyn.ui.elements.LoopNode;
import org.simantics.sysdyn.ui.elements.SysdynElementFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementHints;
import org.simantics.sysdyn.ui.elements.SysdynElementUtils;
import org.simantics.sysdyn.ui.elements.SysdynTextElementNoBounds;
import org.simantics.sysdyn.ui.elements.SysdynTextNode;
import org.simantics.sysdyn.utils.LoopUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class LoopFactory
extends SysdynElementFactory {
    public static final Image LOOP_STATIC_IMAGE = new ShapeImage(LoopFactory.getLoopShape(), null, (Stroke)new BasicStroke(1.0f), true);
    private static Image image = null;

    @Override
    public ElementClass create(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType) throws DatabaseException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        String svgDoc = (String)graph.getPossibleRelatedValue(elementType, g2d.HasSVGDocument);
        String id = "TextElement: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)elementType);
        image = svgDoc != null ? new SVGImage(String.valueOf(id) + ".svg", svgDoc) : (Image)DefaultImages.ERROR_DECORATOR.get();
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{SimpleElementLayers.INSTANCE, OutlinePick.INSTANCE, TextImpl.INSTANCE, TextColorImpl.BLACK, TextFontImpl.DEFAULT, DefaultTransform.INSTANCE, new StaticObjectAdapter((Object)elementType), new StaticSymbolImpl(image), StaticSymbolImageInitializer.INSTANCE, LoopSceneGraph.INSTANCE, new LoopImageSceneGraph(image), HoverImpl.INSTANCE, BoundsOutline.INSTANCE, LoopClockwise.INSTANCE}).setId(LoopFactory.class.getSimpleName());
    }

    static Shape getLoopShape() {
        double x0 = 5.0;
        double y0 = 2.0;
        Path2D.Double loop = new Path2D.Double();
        ((Path2D)loop).moveTo(x0 + 1.0, y0 + 2.0);
        ((Path2D)loop).lineTo(x0 + 0.0, y0 + 0.0);
        ((Path2D)loop).lineTo(x0 - 1.0, y0 + 2.0);
        loop.closePath();
        loop.append(new Arc2D.Double(x0 - 10.0, y0 - 3.0, 10.0, 10.0, 0.0, -270.0, 0), false);
        return loop;
    }

    @Override
    protected String getText(ReadGraph graph, Resource element) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(element, mr.ElementToComponent);
        String text = null;
        if (component != null) {
            text = (String)graph.getPossibleRelatedValue(component, sr.Loop_Comment);
        }
        if (text == null) {
            text = "";
        } else if ("$$AUTO$$".equals(text)) {
            switch (LoopUtils.getLoopType((ReadGraph)graph, (Resource)component)) {
                case BALANCING: {
                    text = "B";
                    break;
                }
                case REINFORCING: {
                    text = "R";
                    break;
                }
                default: {
                    text = "";
                }
            }
        }
        return text;
    }

    @Override
    protected ElementClass compileElementClass(Resource elementType, Collection<ObjectTerminal> terminals) {
        return null;
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        super.load(graph, canvas, diagram, element, e);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Boolean clockwise = (Boolean)graph.getPossibleRelatedValue(element, sr.LoopSymbol_Clockwise, (Binding)Bindings.BOOLEAN);
        if (clockwise == null) {
            clockwise = Boolean.TRUE;
        }
        SysdynElementUtils.setLoopClockwise(e, clockwise);
    }

    public static class LoopImageSceneGraph
    extends ImageClass.StaticImageElementHandler {
        private static final long serialVersionUID = -185893525553743589L;
        private IHintListener hoverHintListener;
        private static final IHintContext.Key NODE = new SceneGraphNodeKey(LoopNode.class, "LOOP_NODE");

        public LoopImageSceneGraph(Image i) {
            super(i);
        }

        public void init(IElement e, G2DParentNode parent) {
            super.init(e, parent);
            LoopNode node = (LoopNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)NODE, (String)"loopHover", LoopNode.class);
            Boolean clockwise = (Boolean)e.getHint(SysdynElementHints.KEY_LOOP_CLOCKWISE);
            SVGNode image = (SVGNode)e.getHint(this.getNodeKey());
            if (clockwise != null && clockwise.booleanValue()) {
                Point2D imageParent = (Point2D)image.localToParent((Point2D)new Point2D.Double(0.0, 0.0)).clone();
                AffineTransform at = new AffineTransform(-1.0, 0.0, 0.0, 1.0, imageParent.getX() + 12.34, imageParent.getY());
                image.setTransform(at);
            }
            RectangularShape bounds = (RectangularShape)image.getBounds().clone();
            node.setShape(bounds);
            Color paint = new Color(0, 0, 0, 0);
            node.setColor(paint);
            Boolean hover = (Boolean)e.getHint(ElementHints.KEY_HOVER);
            node.setHover(hover != null ? hover : false);
            this.hoverHintListener = new IHintListener(){

                public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
                }

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    IElement e = (IElement)sender;
                    LoopNode shape = (LoopNode)((Object)e.getHint(NODE));
                    if (shape == null) {
                        return;
                    }
                    boolean hover = ElementUtils.isHovering((IElement)e);
                    shape.setHover(hover);
                }
            };
            e.addHintListener(this.hoverHintListener);
        }

        public void cleanup(IElement e) {
            super.cleanup(e);
            e.removeHintListener(this.hoverHintListener);
        }
    }

    public static class LoopSceneGraph
    extends SysdynTextElementNoBounds
    implements HandleMouseEvent {
        private static final long serialVersionUID = -5093461687773246286L;
        public static final LoopSceneGraph INSTANCE = new LoopSceneGraph();
        private static final IHintContext.Key NODE = new SceneGraphNodeKey(ShapeNode.class, "LOOP_COMMENT_NODE");

        public LoopSceneGraph() {
            super(0.0, 0.0, Alignment.CENTER, 0.0, 1.0, 1.0, true);
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            super.init(e, parent);
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            LoopNode node = (LoopNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)NODE, (String)"loopComment", LoopNode.class);
            LoopSceneGraph.unflipText(e);
            if (at != null) {
                node.setTransform(at);
                TextNode name = (TextNode)e.getHint(SG_NODE);
                if (name != null) {
                    AffineTransform at2 = (AffineTransform)at.clone();
                    at2.translate(LoopSceneGraph.getXCoordShift(e), LoopSceneGraph.getYCoordShift(e));
                    Alignment alignment = Alignment.CENTER;
                    name.setTransform(at2);
                    if (alignment != null) {
                        name.setHorizontalAlignment((byte)alignment.ordinal());
                        name.setVerticalAlignment((byte)alignment.ordinal());
                    }
                }
            }
        }

        private static double getXCoordShift(IElement e) {
            return 6.3;
        }

        private static double getYCoordShift(IElement e) {
            return -0.3;
        }

        @Override
        protected <T extends SysdynTextNode> Consumer<T> getCallback(final IElement e, G2DParentNode parent, Class<T> nodeClass) {
            return new Consumer<T>(){

                @Override
                public void accept(T node) {
                    node.setTextListener(new ITextListener(){
                        Resource component;

                        public void textChanged() {
                        }

                        public void textEditingStarted() {
                            if (this.component != null) {
                                return;
                            }
                            Object o = e.getHint(ElementHints.KEY_OBJECT);
                            if (o != null && o instanceof Resource) {
                                final Resource element = (Resource)o;
                                Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                                    public void run(ReadGraph graph) throws DatabaseException {
                                        component = graph.getPossibleObject(element, ModelingResources.getInstance((ReadGraph)graph).ElementToComponent);
                                    }
                                });
                            }
                        }

                        public void textEditingCancelled() {
                            TextNode node = (TextNode)e.getHint(SG_NODE);
                            if (node != null) {
                                this.endEdit(node);
                            }
                        }

                        public void textEditingEnded() {
                            TextNode node = (TextNode)e.getHint(SG_NODE);
                            if (node == null) {
                                return;
                            }
                            final String text = node.getText();
                            try {
                                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                                    public void perform(WriteGraph graph) throws DatabaseException {
                                        if (component != null) {
                                            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                                            graph.deny(component, sr.Loop_Comment);
                                            graph.claimLiteral(component, sr.Loop_Comment, (Object)text);
                                        }
                                    }
                                });
                            }
                            catch (DatabaseException e1) {
                                e1.printStackTrace();
                            }
                            IDiagram diagram = ElementUtils.getDiagram((IElement)e);
                            DiagramUtils.synchronizeHintsToBackend((IDiagram)diagram, (IElement[])new IElement[]{e});
                            this.endEdit(node);
                        }
                    });
                }
            };
        }
    }
}

