/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.MissingVariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.elements.ResizeRectangularSceneGraph;
import org.simantics.diagram.elements.TextNode;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.impl.BoundsOutline;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.element.handler.impl.OutlinePick;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.elements.Input;
import org.simantics.sysdyn.ui.elements.SysdynElementFactory;
import org.simantics.sysdyn.ui.elements.SysdynElementUtils;
import org.simantics.sysdyn.ui.elements.SysdynTextElementNoBounds;
import org.simantics.sysdyn.ui.elements.WholeElementTerminals;
import org.simantics.utils.datastructures.hints.IHintContext;

public class InputFactory
extends SysdynElementFactory {
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final Image INPUT_IMAGE = new ShapeImage(InputFactory.getInputShape(), null, (Stroke)STROKE, true);

    static Shape getInputShape() {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-6.0, -1.0);
        ((Path2D)path).lineTo(-1.0, -1.0);
        ((Path2D)path).lineTo(-1.0, -2.5);
        ((Path2D)path).lineTo(1.5, 0.0);
        ((Path2D)path).curveTo(1.5, -2.5, 6.5, -2.5, 6.5, 0.0);
        ((Path2D)path).curveTo(6.5, 2.5, 1.5, 2.5, 1.5, 0.0);
        ((Path2D)path).lineTo(-1.0, 2.5);
        ((Path2D)path).lineTo(-1.0, 1.0);
        ((Path2D)path).lineTo(-6.0, 1.0);
        path.closePath();
        return path;
    }

    @Override
    protected ElementClass compileElementClass(Resource elementType, Collection<ObjectTerminal> terminals) {
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{SimpleElementLayers.INSTANCE, OutlinePick.INSTANCE, TextImpl.INSTANCE, TextColorImpl.BLACK, TextFontImpl.DEFAULT, DefaultTransform.INSTANCE, new StaticObjectAdapter((Object)elementType), new StaticSymbolImpl(INPUT_IMAGE), StaticSymbolImageInitializer.INSTANCE, Input.INSTANCE, new InputSceneGraph(0.0, 0.0, Alignment.CENTER, 0.0, 1.5, 1.5, true), BoundsOutline.INSTANCE, ResizeRectangularSceneGraph.INSTANCE, RESIZE_PROPERTY_SETTER, new WholeElementTerminals(terminals)}).setId(InputFactory.class.getSimpleName());
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        String referenceName;
        String moduleName;
        Resource refersTo;
        block12: {
            super.load(graph, canvas, diagram, element, e);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            Resource component = null;
            Resource dependency = null;
            refersTo = null;
            Resource module = null;
            moduleName = "";
            referenceName = "";
            component = graph.getPossibleObject(element, mr.ElementToComponent);
            if (component != null) {
                dependency = graph.getPossibleObject(component, sr.Variable_isHeadOf);
            }
            if (dependency != null) {
                refersTo = graph.getPossibleObject(dependency, sr.Dependency_refersTo);
                if (refersTo != null) {
                    referenceName = (String)graph.getPossibleRelatedValue(refersTo, l0.HasName);
                    module = graph.getPossibleObject(dependency, sr.Variable_HasTail);
                    moduleName = (String)graph.getPossibleRelatedValue(module, l0.HasName);
                }
            } else {
                Resource runtime = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RUNTIME_RESOURCE);
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                String variable = (String)graph.getPossibleRelatedValue(runtime, dr.RuntimeDiagram_HasVariable);
                if (variable == null) {
                    return;
                }
                try {
                    Variable v = Variables.getVariable((ReadGraph)graph, (String)variable);
                    if (v != null) {
                        module = v.getRepresents(graph);
                    }
                    if (module == null) break block12;
                    for (Resource dep : graph.getObjects(module, sr.Variable_isHeadOf)) {
                        Resource reference = graph.getPossibleObject(dep, sr.Dependency_refersTo);
                        if (reference == null || !reference.equals(component)) continue;
                        refersTo = graph.getSingleObject(dep, sr.Variable_HasTail);
                        referenceName = (String)graph.getPossibleRelatedValue(refersTo, l0.HasName);
                        Variable parent = null;
                        parent = v.getParent(graph);
                        Resource represents = parent.getRepresents(graph);
                        if (parent != null && !graph.isInstanceOf(represents, sr.Configuration) && !graph.isInstanceOf(represents, sr.Experiment_Run)) {
                            moduleName = parent.getName(graph);
                        }
                        break;
                    }
                }
                catch (MissingVariableException missingVariableException) {
                    // empty catch block
                }
            }
        }
        String inputReference = null;
        if (moduleName != null && refersTo != null) {
            inputReference = String.valueOf(moduleName) + "." + referenceName;
        }
        if (inputReference == null) {
            inputReference = "";
        }
        SysdynElementUtils.setInputReference(e, inputReference);
        Font font = ElementUtils.getTextFont((IElement)e);
        font = font.deriveFont(font.getStyle());
        ElementUtils.setTextFont((IElement)e, (Font)font);
    }

    public static class InputSceneGraph
    extends SysdynTextElementNoBounds
    implements InternalSize {
        private static final long serialVersionUID = -3713275157729126409L;
        public static final IHintContext.Key INPUT_SG_NODE = new SceneGraphNodeKey(TextNode.class, "INPUT_SG_NODE");
        private final double originX;
        private final Alignment horizontalAlignment;

        public InputSceneGraph(double originX, double originY, Alignment horizontalAlignment, double borderWidth, double paddingX, double paddingY, boolean editable) {
            super(originX, originY, horizontalAlignment, borderWidth, paddingX, paddingY, editable);
            this.originX = originX;
            this.horizontalAlignment = horizontalAlignment;
        }

        @Override
        public void init(IElement e, G2DParentNode parent) {
            super.init(e, parent);
            TextNode node = (TextNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)INPUT_SG_NODE, (String)"input", TextNode.class);
            Font font = ElementUtils.getTextFont((IElement)e);
            font = font.deriveFont(10.0f);
            Color color = new Color(150, 150, 150);
            Color fillColor = ElementUtils.getFillColor((IElement)e);
            Color borderColor = ElementUtils.getBorderColor((IElement)e, (Color)Color.BLACK);
            String text = SysdynElementUtils.getInputReference(e);
            double scale = 0.235;
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            node.init(text, font, color, this.originX, this.originY, scale);
            node.setBackgroundColor(fillColor);
            node.setBorderColor(borderColor);
            node.setHorizontalAlignment((byte)this.horizontalAlignment.ordinal());
            node.setBorderWidth(0.0f);
            node.setEditable(false);
            node.setShowSelection(false);
            if (at != null) {
                node.setTransform(at);
                AffineTransform at2 = (AffineTransform)at.clone();
                at2.translate(0.0, (double)font.getSize2D() * scale);
                node.setTransform(at2);
            }
            InputSceneGraph.unflipText(e);
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            TextNode name = (TextNode)e.getHint(SG_NODE);
            TextNode reference = (TextNode)e.getHint(INPUT_SG_NODE);
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            if (name != null) {
                size.setRect(name.getBoundsInLocal());
            }
            if (reference == null) {
                size.setFrame(0.0, 0.0, 0.0, 0.0);
            }
            return size;
        }
    }
}

