/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.impl.BorderColorImpl;
import org.simantics.g2d.element.handler.impl.BoundsOutline;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.HoverImpl;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.element.handler.impl.OutlinePick;
import org.simantics.g2d.element.handler.impl.SimpleElementLayers;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextFontImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.sysdyn.ui.elements.HoverShapeNode;
import org.simantics.sysdyn.ui.elements.SysdynElementFactory;
import org.simantics.sysdyn.ui.elements.WholeElementTerminals;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class CloudFactory
extends SysdynElementFactory {
    public static final double CLOUD_SIZE_X = 2.5;
    public static final double CLOUD_SIZE_Y = 1.7;
    public static final double CLOUD_CURVES = 7.0;
    private static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final Image CLOUD_IMAGE = new ShapeImage(CloudFactory.getCloudShape(), null, (Stroke)STROKE, true);

    static Shape getCloudShape() {
        Path2D.Double path = new Path2D.Double();
        double ox = 2.5;
        double oy = 0.0;
        double posX = 0.0;
        double posY = 0.0;
        ((Path2D)path).moveTo(posX + ox, posY + oy);
        int i = 1;
        while ((double)i < 8.0) {
            double angle = 0.8975979010256552 * (double)i;
            double x = Math.cos(angle) * 2.5;
            double y = Math.sin(angle) * 1.7;
            ((Path2D)path).curveTo(posX + (2.0 * ox + x) * 0.5, posY + (2.0 * oy + y) * 0.5, posX + (ox + 2.0 * x) * 0.5, posY + (oy + 2.0 * y) * 0.5, posX + x, posY + y);
            ox = x;
            oy = y;
            ++i;
        }
        return path;
    }

    public static ElementClass createElementClass(Resource elementType, Collection<ObjectTerminal> terminals) {
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{SimpleElementLayers.INSTANCE, OutlinePick.INSTANCE, TextImpl.INSTANCE, TextColorImpl.BLACK, TextFontImpl.DEFAULT, DefaultTransform.INSTANCE, new StaticObjectAdapter((Object)elementType), new StaticSymbolImpl(CLOUD_IMAGE), StaticSymbolImageInitializer.INSTANCE, CloudSceneGraph.INSTANCE, HoverImpl.INSTANCE, BoundsOutline.INSTANCE, new BorderColorImpl(Color.BLACK), new WholeElementTerminals(terminals)}).setId(CloudFactory.class.getSimpleName());
    }

    @Override
    public void load(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource element, IElement e) throws DatabaseException {
        super.load(graph, canvas, diagram, element, e);
        e.setHint(ElementHints.KEY_BORDER_COLOR, e.getHint(ElementHints.KEY_TEXT_COLOR));
    }

    @Override
    protected ElementClass compileElementClass(Resource elementType, Collection<ObjectTerminal> terminals) {
        return CloudFactory.createElementClass(elementType, terminals);
    }

    public static class CloudSceneGraph
    implements SceneGraph,
    InternalSize,
    HandleMouseEvent {
        private static final long serialVersionUID = 5544256245734478634L;
        public static final CloudSceneGraph INSTANCE = new CloudSceneGraph();
        private static final IHintContext.Key NODE = new SceneGraphNodeKey(ShapeNode.class, "CLOUD_NODE");
        private IHintListener hoverHintListener;

        public void init(IElement e, G2DParentNode parent) {
            HoverShapeNode node = (HoverShapeNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)NODE, (String)"cloud", HoverShapeNode.class);
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            node.setStroke(STROKE);
            node.setScaleStroke(true);
            node.setColor(ElementUtils.getBorderColor((IElement)e, (Color)Color.BLACK));
            node.setShape(CloudFactory.getCloudShape());
            if (at != null) {
                node.setTransform(at);
            }
            this.hoverHintListener = new IHintListener(){

                public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
                }

                public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                    IElement e = (IElement)sender;
                    HoverShapeNode shape = (HoverShapeNode)((Object)e.getHint(NODE));
                    if (shape == null) {
                        return;
                    }
                    shape.setHover(ElementUtils.isHovering((IElement)e));
                }
            };
            e.addHintListener(this.hoverHintListener);
        }

        public void cleanup(IElement e) {
            e.removeHintListener(this.hoverHintListener);
            ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)NODE);
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            if (size == null) {
                size = new Rectangle2D.Double();
            }
            size.setFrame(CLOUD_IMAGE.getBounds());
            return size;
        }

        public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
            if (me instanceof MouseEvent.MouseEnterEvent) {
                e.setHint(ElementHints.KEY_HOVER, (Object)true);
                return false;
            }
            if (me instanceof MouseEvent.MouseExitEvent) {
                e.setHint(ElementHints.KEY_HOVER, (Object)false);
                return false;
            }
            return false;
        }
    }
}

